/*$Id: m_divdiff.h,v 16.16 2000/01/04 06:39:57 al Exp $ -*- C++ -*-
 * divided differences
 * in:
 *   c = numerator (data points) (lost)
 *   t = denominator (time)
 *   n = size of array
 *   # of divided differences == n-1
 * out:
 *   c = differences (approx derivatives)
 */
/*--------------------------------------------------------------------------*/
template<class T1, class T2>
inline void divided_differences(T1 c[], int n, const T2 t[])
{
  for (int d=1; d<n; ++d){
    for (int i=n-1; i>=d; --i){
      c[i] = (c[i-1] - c[i]) / (t[i-d] - t[i]);
    }
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
