/*$Id: l_wmatch.cc,v 18.5 2000/07/10 08:36:32 al Exp $ -*- C++ -*-
 * wmatch: string match with wild cards
 * s1 may have wild cards: ? any character matches; * any repeated 0 or more
 * returns true or false
 * normally not case sensitive,
 *	but \ before any letter in s1 forces exact match
 * recursive
 */
#include <ctype.h>
/*--------------------------------------------------------------------------*/
	bool	wmatch(const char*,const char*);
/*--------------------------------------------------------------------------*/
bool wmatch(const char *s2, const char *s1)
{
  {if (!*s2 && !*s1) {			// both end together -- match
    return true;
  }else if (!*s2 || !*s1) {		// ends don't match
    return false;
  }else if (tolower(*s2) == tolower(*s1)) { // one char matches - move on
    return wmatch(s2+1, s1+1);
  }else if (*s1 == '?') {		// ? wild card match - move on
    return wmatch(s2+1, s1+1);
  }else if (*s1 == '*') {		// * (repeat) wild card match
    {if (wmatch(s2+1, s1)) {		// match 1, try for 2
      return true;
    }else if (wmatch(s2, s1+1)) {	// match 0 - continue
      return true;
    }else{				// match 1, only 1
      return wmatch(s2+1, s1+1);
    }}
  }else{				// mismatch
    return false;
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
