/*$Id: l_timer.h,v 16.5 1999/11/25 07:56:24 al Exp $ -*- C++ -*-
 * CPU time accounting
 */
#ifndef U_TIMER_H
#define U_TIMER_H
#include "io_.h"
/*--------------------------------------------------------------------------*/
class TIMER {
private:
  enum {_T_NAME_LEN = 8};
  double _ref_user;	// time the clock was started
  double _ref_system;
  double _last_user;	// time of timed operation
  double _last_system;
  double _total_user;	// time since program start
  double _total_system;
  bool	 _running;
  char	 _name[_T_NAME_LEN+1];
public:
  explicit	TIMER();
  explicit	TIMER(const char*);
  TIMER&	fullreset();
  TIMER&	reset();
  TIMER&	zstart();
  TIMER&	start();
  TIMER&	stop();
  TIMER&	check();
  double	elapsed()const	{return _last_user+_last_system;}
  TIMER&	print(OMSTREAM& s = IO::mstdout);
  TIMER& 	operator=(const TIMER&);
  friend TIMER	operator-(const TIMER&,const TIMER&);
};
template <class T>
T& operator<<(T & s, TIMER & t) {t.print(s); return s;}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
