/*$Id: l_stlextra.h,v 18.4 2000/07/09 05:58:31 al Exp $ -*- C++ -*-
 * extra functions in the STL style
 * Things that ought to be there, but are not
 */
#ifndef L_STLEXTRA_H
#define L_STLEXTRA_H
/*--------------------------------------------------------------------------*/
//InputIterator find_ptr(InputIterator first,InputIterator last,const T& value)
/*--------------------------------------------------------------------------*/
/* find_ptr: like the stl find, except that the list contains pointers
   Dereference the pointer in the list, then compare */
template <class InputIterator, class T>
InputIterator find_ptr(InputIterator first,InputIterator last,const T& value)
{
  while (first != last && **first != value)
    ++first;
  return first;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
