/*$Id: e_subckt.h,v 16.15 1999/12/20 09:18:34 al Exp $ -*- C++ -*-
 * base class for elements made of subcircuits
 */
#ifndef E_SUBCKT_H
#define E_SUBCKT_H
#include "e_compon.h"
/*--------------------------------------------------------------------------*/
class BASE_SUBCKT : public COMPONENT {
protected:
  explicit BASE_SUBCKT()		     :COMPONENT() {}
  explicit BASE_SUBCKT(const BASE_SUBCKT& p) :COMPONENT(p){}
private: // override virtual
  void	  precalc()	{subckt().precalc();}
  void	  dc_begin()	{subckt().dc_begin();}
  void	  tr_begin()	{subckt().tr_begin();}
  void	  tr_restore()	{subckt().tr_restore();}
  void	  dc_advance()	{subckt().dc_advance();}
  void	  tr_advance()	{subckt().tr_advance();}
  bool	  tr_needs_eval(){return subckt().tr_needs_eval();}
  void	  tr_queue_eval(){subckt().tr_queue_eval();}
  bool	  do_tr()	{set_converged(subckt().do_tr()); return converged();}
  void	  tr_load()	{subckt().tr_load();}
  double  tr_review()	{return subckt().tr_review();}
  void	  tr_accept()	{subckt().tr_accept();}
  void	  tr_unload()	{subckt().tr_unload();}
  void	  ac_begin()	{subckt().ac_begin();}
  void	  do_ac()	{subckt().do_ac();}
  void	  ac_load()	{unreachable(); subckt().ac_load();}
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
