/*$Id: e_model.h,v 17.19 2000/04/26 07:30:00 al Exp $ -*- C++ -*-
 * base class for all models
 */
#ifndef E_MODEL_H
#define E_MODEL_H
#include "e_card.h"
/*--------------------------------------------------------------------------*/
// this file
class MODEL_CARD;
/*--------------------------------------------------------------------------*/
// external
class COMPONENT;
/*--------------------------------------------------------------------------*/
class SDP_CARD {
public:
  explicit SDP_CARD(const COMPONENT_COMMON*) {}
  virtual ~SDP_CARD() {}
};
/*--------------------------------------------------------------------------*/
class TDP_CARD {
public:
  explicit TDP_CARD(const CARD*) {}
};
/*--------------------------------------------------------------------------*/
class MODEL_CARD : public CARD{
protected:
  explicit	MODEL_CARD(const MODEL_CARD& p)
					:CARD(p),_tnom(p._tnom){unreachable();}
public:
  explicit	MODEL_CARD();
		~MODEL_CARD();

protected: // override virtuals
  char		id_letter()const	{return '\0';}
  int		numnodes()const		{unreachable(); return 0;}
  CARD*		clone()const		{unreachable(); return 0;}
  void		parse(CS&);
  void		print(OMSTREAM&,int)const;
  
public:
  virtual void	tr_eval(COMPONENT*)const{unreachable();}
  virtual void	ac_eval(COMPONENT*)const{unreachable();}
  virtual SDP_CARD* new_sdp(const COMPONENT_COMMON*)const
					{unreachable();return 0;};
  virtual bool parse_front(CS&) {unreachable(); return false;};
  virtual void parse_params(CS&) {unreachable();};
  virtual void post_parse() {unreachable();};
  virtual void print_front(OMSTREAM&)const {unreachable();};
  virtual void print_params(OMSTREAM&)const {unreachable();};
  virtual void print_calculated(OMSTREAM&)const {unreachable();};
public:
  double _tnom;
};
extern std::list<CARD*> root_model_list;
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
