/*$Id: e_compon.h,v 18.8 2000/07/26 09:26:27 al Exp $ -*- C++ -*-
 * branch structure type definitions
 * device types (enumeration type?)
 */
#ifndef E_COMPON_H
#define E_COMPON_H
#include "m_cpoly.h"
#include "e_card.h"
/*--------------------------------------------------------------------------*/
// this file
class COMPONENT_COMMON;
class COMPONENT;
/*--------------------------------------------------------------------------*/
// external
class MODEL_CARD;
class CS;
class ELEMENT;
/*--------------------------------------------------------------------------*/
inline bool conchk(double o, double n,
		   double a=OPT::abstol, double r=OPT::reltol)
{
  return (abs((n)-(o))<=((r)*abs(n)+(a)));
}
enum {CC_STATIC=27342}; // mid-sized arbitrary positive int
// pass this as an argument to a common constructor to mark it as static,
// so it won't be deleted
/*--------------------------------------------------------------------------*/
class COMPONENT_COMMON {
friend void attach_common(const COMPONENT_COMMON*c,const COMPONENT_COMMON**to);
friend void detach_common(const COMPONENT_COMMON** from);
private:
  COMPONENT_COMMON& operator=(const COMPONENT_COMMON&)
					{unreachable(); return *this;}
protected:
  explicit COMPONENT_COMMON(const COMPONENT_COMMON& p, int c=0)
    :_tnom(p._tnom),_modelname(p._modelname),_model(p._model),_attachcount(c)
    {}
  explicit COMPONENT_COMMON(int c=0)
    :_tnom(NOT_INPUT),_modelname(), _model(0), _attachcount(c) {}
public:
  virtual ~COMPONENT_COMMON();
  //	{assert(_attachcount==0||_attachcount==CC_STATIC);}

  const MODEL_CARD* attach_model()const;
  COMPONENT_COMMON& attach(const MODEL_CARD* m) {_model = m; return *this;}
  COMPONENT_COMMON& set_modelname(const std::string& n)
					{_modelname = n; return *this;}
  COMPONENT_COMMON& parse_modelname(CS&);

  virtual void	parse(CS&)		{unreachable();}
  virtual void	print(OMSTREAM&)const	{unreachable();}

  virtual void	tr_eval(ELEMENT*x)const;
  virtual void	ac_eval(ELEMENT*x)const;
  virtual bool	has_tr_eval()const	{untested(); return false;}
  virtual bool	has_ac_eval()const	{untested(); return false;}
  virtual const COMPONENT_COMMON* deflate()const {return this;}

  virtual const char* name()const	= 0;
  const std::string&  modelname()const	{return _modelname;}
  const MODEL_CARD*   model()const	{assert(_model); return _model;}
	  bool	      has_model()const	{return _model;}
private:
  const COMPONENT_COMMON* a_ttach()const	{++_attachcount; return this;}
  int d_etach()const		{assert(_attachcount>0);return --_attachcount;}
protected:
  double	_tnom;
private:
  std::string	_modelname;
  mutable const MODEL_CARD* _model;
public:
  mutable int	_attachcount;
};
/*--------------------------------------------------------------------------*/
/* note on _attachcount ...
 * The int argument is the initial _attachcount (default = 0)
 * Set it to CC_STATIC for static default versions that will never be deleted.
 * Set it to 0 (default) for auto versions, so they can be deleted.
 * A common will not be deleted on a detach if its _attachcount != 0
 * A failed assertion from the common destructor probably means
 * the common is being deleted before a device it is attached to is,
 * without being first detached.
 * This is why ~COMPONENT destroys the subckt explicitly.
 *
 * Static commons (CC_STATIC) must be in file scope, not in function scope,
 * because local statics are deleted first, before any globals.
 * BUG:: possible portability problem.  What is deletion order?
 */
/*--------------------------------------------------------------------------*/
class COMPONENT : public CARD {
protected:
  explicit   COMPONENT();
  explicit   COMPONENT(const COMPONENT& p);
	     ~COMPONENT()		{subckt().destroy(); detach_common();}
public:
  virtual const char* dev_type()const = 0;
  virtual int	      numnodes()const = 0;
protected:
  int	parse_nodes(CS&,int,int,int=0);
  void	printnodes(OMSTREAM&,int,int=0)const;
  bool	is_device()const		{return true;}

  const MODEL_CARD* attach_model()const	
		{return (has_common() ? _common->attach_model() : 0);}
  void	attach_common(const COMPONENT_COMMON*c) {::attach_common(c,&_common);}
  void	detach_common()			{::detach_common(&_common);}

  bool	converged()const		{return _converged;}
  void	set_converged(bool s=true)	{_converged = s;}
  void	set_not_converged()		{_converged = false;}

  void	expandsubckt(const std::string& modelname);
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // list and queue management
  bool	is_q_for_eval() {return (_queued_for_eval>=STATUS::iter[iTOTAL]);}
  bool	qfe();
  void	q_eval();
  void	q_load()	{SIM::loadq.push_back(this);}
  void	q_accept()	{SIM::acceptq.push_back(this);}
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // modifiers
public:
  void	set(const std::string& Label, CARD* Parent,
	    const COMPONENT_COMMON* Common, double Value,
	    const node_t& N0, const node_t& N1,
	    const node_t& N2 = node_t(), const node_t& N3 = node_t());
  void	set_slave()	{_queued_for_eval = INT_MAX; subckt().set_slave();}
  void	set_value(double v)			      {CARD::set_value(v);}
  void	set_value(double v, const COMPONENT_COMMON* c){_common=c;set_value(v);}
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // querys
  bool	is_slave()const	  {untested(); return (_queued_for_eval==INT_MAX);}
  bool	has_common()const {return _common;}
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // data access
  const COMPONENT_COMMON* common()const	{return _common;}
private:
  const COMPONENT_COMMON* _common;
private:
  bool _converged;	// convergence status
  int  _queued_for_eval;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
inline bool COMPONENT::qfe()
{
  {if (is_q_for_eval()){
    unreachable();
    return true;
  }else{
    _queued_for_eval=STATUS::iter[iTOTAL];
    return false;
  }}
}
/*--------------------------------------------------------------------------*/
inline void COMPONENT::q_eval()
{
  {if(!qfe()){
    SIM::evalq_uc->push_back(this);
  }else{
    unreachable();
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
