/*$Id: e_compon.cc,v 18.8 2000/07/26 09:26:27 al Exp $ -*- C++ -*-
 * Base class for elements of a circuit
 */
#include "l_stlextra.h"
#include "ap.h"
#include "e_model.h"
//#include "e_compon.h"
#include "e_elemnt.h" // includes e_compon.h
/*--------------------------------------------------------------------------*/
static	int	name2number(CS&);
/*--------------------------------------------------------------------------*/
COMPONENT_COMMON::~COMPONENT_COMMON()
{
  trace1("common", _attachcount);
  assert(_attachcount==0||_attachcount==CC_STATIC);
}
/*--------------------------------------------------------------------------*/
const MODEL_CARD* COMPONENT_COMMON::attach_model()const
{
  std::list<CARD*>::const_iterator mi =
    find_ptr(root_model_list.begin(), root_model_list.end(), _modelname);
  {if (mi == root_model_list.end()){
    untested();
    error(bERROR, "can't find model: " + modelname() + '\n');
    _model = 0;
  }else{
    _model = dynamic_cast<const MODEL_CARD*>(*mi);
    if (!_model){
      untested();
      error(bERROR, modelname() + " is not a .model\n");
    }
  }}
  return _model;
}
/*--------------------------------------------------------------------------*/
COMPONENT_COMMON& COMPONENT_COMMON::parse_modelname(CS& cmd)
{
  return set_modelname(cmd.ctos(TOKENTERM));
}
/*--------------------------------------------------------------------------*/
void COMPONENT_COMMON::tr_eval(ELEMENT*x)const
{
  untested();
  assert(_model);
  _model->tr_eval(x);
}
/*--------------------------------------------------------------------------*/
void COMPONENT_COMMON::ac_eval(ELEMENT*x)const
{
  untested();
  assert(_model);
  _model->ac_eval(x);
}
/*--------------------------------------------------------------------------*/
COMPONENT::COMPONENT()
  :CARD(),
   _common(0),
   _converged(false),
   _queued_for_eval(-1)
{
}
/*--------------------------------------------------------------------------*/
COMPONENT::COMPONENT(const COMPONENT& p)
  :CARD(p),
   _common(0), 
   _converged(p._converged),
   _queued_for_eval(-1)
{
  attach_common(p._common);
  assert(_common == p._common);
}
/*--------------------------------------------------------------------------*/
/* parse_nodes: parse circuit connections from input string
 * n array must hold at least numnodes+1
 * fills in the rest of the array with INVALIDNODE
 * returns the number of nodes actually read
 */
int COMPONENT::parse_nodes(CS& cmd, int numnodes, int minfill, int start)
{
  int count = 0;
  if (start < numnodes){
    int paren = cmd.skiplparen();
    for (int ii = start;  ii < numnodes;  ++ii){
      _n[ii].t = _n[ii].e = name2number(cmd);
      if (_n[ii].e != INVALIDNODE){
	count = ii+1;
      }else{
	if (ii <= minfill){
	  cmd.warn(bDANGER, "need mode nodes");
	  _n[ii].t = _n[ii].e = 0;
	}
      }
    }
    _n[numnodes].t = _n[numnodes].e = INVALIDNODE;
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
  }
  return count;
}
/*--------------------------------------------------------------------------*/
/* printnodes: print a node list
 */
void COMPONENT::printnodes(OMSTREAM& where, int numnodes, int start)const
{
  for (int ii = start;  ii < numnodes  &&  _n[ii].e != INVALIDNODE;  ++ii){
    where << "  " << _n[ii];
  }
}
/*--------------------------------------------------------------------------*/
/* set: set values, used in model building, 2 node version
 */
void COMPONENT::set(const std::string& Label, CARD *Owner,
		    const COMPONENT_COMMON *Common, double Value,
		    const node_t& N0, const node_t& N1,
		    const node_t& N2, const node_t& N3)
{
  set_Label(Label);
  set_owner(Owner);
  set_value(Value);
  attach_common(Common);
  _n[0] = N0;
  _n[1] = N1;
  _n[2] = N2;
  _n[3] = N3;
}
/*--------------------------------------------------------------------------*/
void attach_common(const COMPONENT_COMMON *c, const COMPONENT_COMMON** to)
{
  assert(to);
  {if (!c){
    // there is no new common.  probably a simple element
    detach_common(to);
  }else if (!*to){
    // no old one, but have a new one
    *to = c->a_ttach();
  }else{ /* if (1 || *c != *common){*/
    // they are different
    detach_common(to);
    *to = c->a_ttach();
#if 0
  }else{
    untested();
    // The one already attached matches the new one. 
    // use the old one and throw away the new one.
    // doesn't work.  always assume different as workaround
    delete c;
#endif
  }}
}
/*--------------------------------------------------------------------------*/
void detach_common(const COMPONENT_COMMON** from)
{
  assert(from);
  if (*from){
    if ((**from).d_etach() == 0){
      trace1("delete", (**from)._attachcount);
      delete *from;
    }else{
      trace1("nodelete", (**from)._attachcount);
    }
    *from = NULL;
  }
}
/*--------------------------------------------------------------------------*/
/* name2number: convert node name to node number
 * returns node number
 * cnt updated
 */
static int name2number(CS& cmd)
{
  int test = cmd.cursor();
  int node = cmd.ctoi();
  {if (test == cmd.cursor()) {
    return INVALIDNODE;
  }else{
    return node;
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
