/*$Id: e_ccsrc.h,v 17.1 2000/02/19 08:51:13 al Exp $ -*- C++ -*-
 $ current controlled source base
 */
#ifndef E_CCSRC_H
#define E_CCSRC_H
#include "l_denoise.h"
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
class CCSRC_BASE : public ELEMENT {
  friend class DEV_MUTUAL_L;
protected:
  explicit	CCSRC_BASE()
    :ELEMENT(), _input_label(), _input(0) {}
  explicit	CCSRC_BASE(const CCSRC_BASE& p)
    :ELEMENT(p), _input_label(p._input_label), _input(p._input) {untested();}
protected: // override virtual
  int	   numnodes()const	{return 4;}
  void	   parse_more_nodes(CS&, int);
  void	   print(OMSTREAM& where, int detail)const;
  void	   expand();
  bool	   tr_needs_eval()	{untested(); return true;}
  void	   tr_queue_eval()	{q_eval();}
  void	   tr_unload()		{untested(); tr_unload_active();}
  double   tr_involts()const
		{untested(); return dn_diff(_n[IN1].v0(), _n[IN2].v0());}
  double   tr_involts_limited()const {return volts_limited(_n[IN1],_n[IN2]);}
  COMPLEX  ac_involts()const {untested();return _n[IN1].vac()-_n[IN2].vac();}
  bool	   is_2port()const		{return true;}  
protected:
  std::string	_input_label;
  ELEMENT*	_input;
private:
  enum	{PRINTNODES = 2};
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
