/*$Id: e_card.h,v 18.11 2000/08/30 05:19:43 al Exp $ -*- C++ -*-
 * base class for anything in a netlist or circuit file
 */
#include "e_node.h"
#include "e_cardlist.h"
#ifndef E_CARD_H
#define E_CARD_H
/*--------------------------------------------------------------------------*/
// this file
class CARD;
/*--------------------------------------------------------------------------*/
// external
class CS;
class COMPONENT_COMMON;
/*--------------------------------------------------------------------------*/
class CARD : public CKT_BASE {
private:
  int		_evaliter;	// model eval iteration number
  CARD_LIST	_subckt;
  CARD*		_owner;
public: //insert, s__init, s__map
  node_t*	_n;
private:
  node_t	_nodes[NODESPERBRANCH+1]; // nodes (0,1:out, 2,3:in)
  double	_value;		// value, for simple parts
  bool		_constant;	// eval stays the same every iteration
  //--------------------------------------------------------------------
protected:   				// traversal functions
  CARD*	   find_in_scope(const std::string& name);
  //--------------------------------------------------------------------
public:					// virtuals. -- the important stuff
  virtual char	 id_letter()const	= 0;
  virtual CARD*	 clone()const		= 0;
  virtual void	 parse(CS&)		= 0;
  virtual void	 print(OMSTREAM&,int)const = 0;
  virtual void	 expand()		{}
  virtual void	 precalc()		{}
  virtual void	 dc_begin()		{}
  virtual void	 tr_begin()		{}
  virtual void	 tr_restore()		{}
  virtual void	 dc_advance()		{}
  virtual void	 tr_advance()		{}
  virtual bool	 tr_needs_eval()	{untested(); return false;}
  virtual void	 tr_queue_eval()	{}
  virtual bool	 do_tr()		{return true;};
  virtual void	 tr_load()		{}
  virtual double tr_review()		{return NEVER;}
  virtual void	 tr_accept()		{}
  virtual void	 tr_unload()		{}
  virtual void	 ac_begin()		{}
  virtual void	 do_ac()		{}
  virtual void	 ac_load()		{}
  //--------------------------------------------------------------------
  // virtuals defined in base, not overridden here
  // shown here only to complete the list
  //virtual double tr_probe_num(CS&)const;
  //virtual XPROBE ac_probe_ext(CS&)const;
  //--------------------------------------------------------------------
protected:				// create and destroy.
  explicit CARD();
  explicit CARD(const CARD&);
public:
  virtual  ~CARD()			{}
  //--------------------------------------------------------------------
public:					// query functions.
  static double	probe(const CARD*,const std::string&);
  int		connects_to(int node)const;
  //--------------------------------------------------------------------
protected:				// query functions. deferred inline
  bool	evaluated();
  //--------------------------------------------------------------------
public:					// query functions. virtual constant
  virtual bool	is_1port()const		{return false;}
  virtual bool	is_2port()const		{return false;}
  virtual bool	is_source()const	{return false;}
  virtual bool	f_is_value()const	{return false;}
  virtual bool	is_device()const	{return false;}
  //--------------------------------------------------------------------
public:					// query functions.
  CARD_LIST&	     subckt()		{return _subckt;}
  const CARD_LIST&   subckt()const	{return _subckt;}
  double	     value()const	{return _value;}
  const std::string  long_label()const; /* virtual */
  CARD*		     owner()const	{return _owner;}
  int		     evaliter()const	{return STATUS::iter[iTOTAL];}
  bool		     constant()const	{return _constant;}
  //--------------------------------------------------------------------
public:					// modifiers.
  virtual void	set_slave()		{untested(); subckt().set_slave();}
  virtual void  set_value(double v)	{_value = v;}
  virtual void  set_value(double v, const COMPONENT_COMMON*)
					{untested(); set_value(v);}
  double* set_value()		{return &_value;}
  void	  parse_label(CS&);
  void	  parse_Label(CS&);
  void	  set_owner(CARD* o)	{assert(!_owner||_owner==o); _owner=o;}
  void	  set_constant(bool c)	{_constant = c;}
  //--------------------------------------------------------------------
  // a very bad way to do parameter passing between the device and expression
  static double initial_condition;
  //--------------------------------------------------------------------
  friend class CARD_LIST;
  friend CARD_LIST::fat_iterator findbranch(CS&,CARD_LIST::fat_iterator);
};
/*--------------------------------------------------------------------------*/
inline bool CARD::evaluated()
{
  if (_evaliter == STATUS::iter[iTOTAL]){
    return true;
  }else{
    _evaliter = STATUS::iter[iTOTAL];
    return false;
  }
}
/*--------------------------------------------------------------------------*/
inline CARD_LIST::fat_iterator findbranch(CS& cmd, CARD_LIST* cl){
  return findbranch(cmd, CARD_LIST::fat_iterator(cl));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
