/*$Id: d_vcr.h,v 17.21 2000/05/02 09:32:08 al Exp $ -*- C++ -*-
 * Voltage controlled resistance
 */
#ifndef D_VCR_H
#define D_VCR_H
#include "e_elemnt.h"

/*--------------------------------------------------------------------------*/
class DEV_VCR : public ELEMENT {
private:
  explicit DEV_VCR(const DEV_VCR& p) :ELEMENT(p) {untested();}
public:
  explicit DEV_VCR()		:ELEMENT() {}
private: // override virtual
  char	   id_letter()const	{return '\0';}
  const char* dev_type()const	{return "vcr";}
  int	   numnodes()const	{return 4;}
  bool	   is_2port()const	{return true;}
  CARD*	   clone()const		{untested(); return new DEV_VCR(*this);}
  //void   parse(CS&);		//ELEMENT
  //void   print(OMSTREAM,int)const; //ELEMENT
  //void   expand();		//CARD/nothing
  void	   precalc();

  //void   dc_begin();		//CARD/nothing
  //void   tr_begin();		//CARD/nothing
  //void   tr_restore();	//CARD/nothing
  //void   dc_advance();	//CARD/nothing
  //void   tr_advance();	//CARD/nothing
  //bool   tr_needs_eval();	//ELEMENT
  //void   tr_queue_eval();	//ELEMENT
  bool	   do_tr();
  void	   tr_load()		{tr_load_shunt(); tr_load_active();}
  //double tr_review();		//CARD/nothing
  //void   tr_accept();		//CARD/nothing
  void	   tr_unload()	{untested(); tr_unload_shunt(); tr_unload_active();}
  //double tr_amps()const	//ELEMENT
  double tr_involts()const
		{untested(); return dn_diff(_n[IN1].v0(), _n[IN2].v0());}
  double   tr_involts_limited()const {return volts_limited(_n[IN1],_n[IN2]);}
  //double tr_probe_num(CS&)const;//ELEMENT

  void	   ac_begin();
  void	   do_ac();
  void	   ac_load()		{ac_load_loss(); ac_load_active();}
  COMPLEX  ac_involts()const {untested(); return _n[IN1].vac()-_n[IN2].vac();}
  //XPROBE ac_probe_ext(CS&)const;//ELEMENT
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
