/*$Id: d_trln.h,v 17.21 2000/05/02 09:32:08 al Exp $ -*- C++ -*-
 * transmission lines
 */
#ifndef D_TRNLIN_H
#define D_TRNLIN_H
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
enum {NUM_INIT_COND = 4};
/*--------------------------------------------------------------------------*/
class WAVE {
private:
  std::deque<std::pair<double,double> > _w;
  double _delay;
  explicit WAVE(const WAVE&);
public:
  explicit WAVE(double d=0);
  void	   set_delay(double d);
  void	   initialize();
  void	   push(double t, double v);
  double   v_out(double t)const;
  double   v_reflect(double t, double v_total)const;
};
/*--------------------------------------------------------------------------*/
class TRANSLINE_COMMON : public COMPONENT_COMMON {
public:
  explicit TRANSLINE_COMMON(int c=0);
  explicit TRANSLINE_COMMON(const TRANSLINE_COMMON& p);
  const char* name()const	{untested(); return "transline";}
  double   z0;			/* characteristic impedance */
  double   td;			/* delay time */
  double   f;			/* specification frequency */
  double   nl;			/* length (wavelengths) at f */
  double   ic[NUM_INIT_COND];	/* initial conditions: v1, i1, v2, i2 */
  int	   icset;		/* flag: initial condition set */
};
/*--------------------------------------------------------------------------*/
class DEV_TRANSLINE : public ELEMENT {
private:
  WAVE	 _forward;
  WAVE	 _reflect;
  double _if0; // value of current source representing incident wave
  double _ir0; // value of current source representing reflected wave
  double _if1; // val of cs rep incident wave, one load ago
  double _ir1; // val of cs rep reflected wave, one load ago
  COMPLEX _y11;// AC equiv ckt
  COMPLEX _y12;// AC equiv ckt
private:
  explicit	DEV_TRANSLINE(const DEV_TRANSLINE& p)
    :ELEMENT(p), _forward(), _reflect(), _if0(0), _ir0(0), _if1(0), _ir1(0)
    {untested();}
public:
  explicit	DEV_TRANSLINE();
private: // override virtual
  char		id_letter()const	{return 'T';}
  const char*	dev_type()const		{untested(); return "tline";}
  int		numnodes()const		{return 4;}
  CARD*		clone()const	{untested();return new DEV_TRANSLINE(*this);}
  void		parse(CS&);
  void		print(OMSTREAM&,int)const;
  //void	expand();		//CARD/nothing
  void		precalc();

  void		dc_begin()		{untested();}
  void		tr_begin();
  //void	tr_restore();		//CARD/nothing
  void		dc_advance()		{tr_advance();}
  void		tr_advance();
  bool		tr_needs_eval()	{return (_if0 != _if1  ||  _ir0 != _ir1);}
  void		tr_queue_eval()	{if(tr_needs_eval()){q_eval();}}
  bool		do_tr();
  void		tr_load();
  double	tr_review();
  void		tr_accept();
  void		tr_unload();
  double	tr_involts()const
			{return dn_diff(_n[IN1].v0(), _n[IN2].v0());}
  double	tr_involts_limited()const
			{unreachable(); return volts_limited(_n[IN1],_n[IN2]);}
  //double	tr_probe_num(CS&)const;	//ELEMENT wrong???

  //void	ac_begin();		//CARD/nothing
  void		do_ac();
  void		ac_load();
  COMPLEX	ac_involts()const 
			{untested(); return _n[IN1].vac() - _n[IN2].vac();}
  //XPROBE	ac_probe_ext(CS&)const;	//ELEMENT wrong??

  bool		is_2port()const		{untested(); return true;}
private:
  void		setinitcond(CS&);
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
