/*$Id: d_subckt.h,v 17.21 2000/05/02 09:32:08 al Exp $ -*- C++ -*-
 * data structures for subcircuits
 */
#ifndef D_SUBCKT_H
#define D_SUBCKT_H
#include "e_subckt.h"
/*--------------------------------------------------------------------------*/
#define NODESPERSUBCKT 1000
#define PORTSPERSUBCKT 100
/*--------------------------------------------------------------------------*/
class DEV_SUBCKT : public BASE_SUBCKT {
private:
  explicit	DEV_SUBCKT(const DEV_SUBCKT&);
public:
  explicit	DEV_SUBCKT();
		~DEV_SUBCKT()	{--_count;}
private: // override virtual
  char		id_letter()const	{return 'X';}
  const char*	dev_type()const		{untested(); return "subckt";}
  int		numnodes()const		{untested(); return 0;}
  CARD*		clone()const		{return new DEV_SUBCKT(*this);}
  void		parse(CS&);
  void		print(OMSTREAM&,int)const;
  void		expand();
  double	tr_probe_num(CS&)const;
public:
  static int	count()			{return _count;}
private:
  static int	_count;
  node_t	_nodes[PORTSPERSUBCKT+1];
};
/*--------------------------------------------------------------------------*/
class SUBCKT_COMMON : public COMPONENT_COMMON {
public:
  explicit SUBCKT_COMMON(int c=0)		:COMPONENT_COMMON(c){++_count;}
  explicit SUBCKT_COMMON(const SUBCKT_COMMON& p):COMPONENT_COMMON(p){++_count;}
	   ~SUBCKT_COMMON()			{--_count;}
  const char*	name()const			{untested(); return "subckt";}
  static int	count()				{return _count;}
private:
  static int	_count;
};
/*--------------------------------------------------------------------------*/
class MODEL_SUBCKT : public COMPONENT {
private:
  explicit	MODEL_SUBCKT(const MODEL_SUBCKT&p):COMPONENT(p){unreachable();}
public:
  explicit	MODEL_SUBCKT();
		~MODEL_SUBCKT();
private: // override virtual
  char		id_letter()const	{return '\0';}
  const char*   dev_type()const	{untested(); return "";}
  int	        numnodes()const	{untested(); return 0;}
  CARD*		clone()const	{untested(); return new MODEL_SUBCKT(*this);}
  void		parse(CS&);
  void		print(OMSTREAM&,int)const;
  bool		is_device()const	{return false;}
public:
  static int	count()			{return _count;}
private:
  node_t	_nodes[PORTSPERSUBCKT+1];
  static int	_count;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
