/* $Id: d_mos123.cc,v 18.16 2000/09/02 08:28:23 al Exp $ -*- C++ -*-
 * MOS model - base for levels 1,2,3,6
 */
/* This file is automatically generated. DO NOT EDIT */
#include "ap.h"
#include "d_mos123.h"
/*--------------------------------------------------------------------------*/
const double NA(NOT_INPUT);
/*--------------------------------------------------------------------------*/
int MODEL_MOS123::_count = 0;
/*--------------------------------------------------------------------------*/
SDP_MOS123::SDP_MOS123(const COMPONENT_COMMON* cc)
  :SDP_MOS_BASE(cc)
{
  assert(cc);
  const MOS_COMMON* c = prechecked_cast<const MOS_COMMON*>(cc);
  assert(c);
  const MODEL_MOS123* m = prechecked_cast<const MODEL_MOS123*>(c->model());
  assert(m);
  le = le - 2. * m->ld;
  cgate = m->cox * we * le;
  phi = m->phi;
}
/*--------------------------------------------------------------------------*/
TDP_MOS123::TDP_MOS123(const DEV_MOS* d)
  :TDP_MOS_BASE(d)
{
}
/*--------------------------------------------------------------------------*/
MODEL_MOS123::MODEL_MOS123()
  :MODEL_MOS_BASE(),
   vto(NA),
   gamma(NA),
   phi(NA),
   lambda(NA),
   tox(NA),
   nsub(NA),
   nss(0.0),
   xj(NA),
   ld(0.0),
   uo((600.*CM2M2)),
   tpg(gtOPP),
   cox(NA),
   calc_vto(false),
   calc_gamma(false),
   calc_phi(false)
{
  ++_count;
  cjo = 0.;
  pb = 0.8;
  pbsw = NA;
}
/*--------------------------------------------------------------------------*/
bool MODEL_MOS123::parse_front(CS& cmd)
{
  return MODEL_MOS_BASE::parse_front(cmd);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::parse_params(CS& cmd)
{
  get(cmd, "VTO", &vto, mSCALE, (static_cast<double>(polarity)));
  get(cmd, "GAmma", &gamma);
  get(cmd, "PHI", &phi, mPOSITIVE);
  get(cmd, "LAmbda", &lambda);
  get(cmd, "TOX", &tox, mPOSITIVE);
  get(cmd, "NSUb", &nsub, mSCALE, ICM2M3);
  get(cmd, "NSS", &nss, mSCALE, ICM2M2);
  get(cmd, "XJ", &xj, mPOSITIVE);
  get(cmd, "LD", &ld);
  get(cmd, "UO", &uo, mSCALE, CM2M2);
  get(cmd, "TPG", &tpg);
  MODEL_MOS_BASE::parse_params(cmd);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::post_parse()
{
  MODEL_MOS_BASE::post_parse();

      {if (tpg < 0) {		// coerce tpg to a proper value
	tpg = gtSAME;		
      }else if (tpg > 0) {
	tpg = gtOPP;
      }else{
	assert(tpg == gtMETAL);
      }}
      if (tox != NA && tox <= 0) {
	untested();
	tox = NA;
	error(bWARNING, long_label()+": tox <= 0, treating as if not input\n");
      }
      if (nsub != NA && nsub < NI) {
	untested();
	nsub = NA;
	error(bWARNING,long_label()+": nsub < ni, treating as if not input\n");
      }

  if (pbsw == NA) {
    pbsw = pb;
  }
  cmodel = ((!cmodel)?3:cmodel);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::print_front(OMSTREAM& o)const
{
  MODEL_MOS_BASE::print_front(o);
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::print_params(OMSTREAM& o)const
{
  MODEL_MOS_BASE::print_params(o);
  if (!calc_vto)
    o << "  vto=" << vto/((static_cast<double>(polarity)));
  if (!calc_gamma)
    o << "  gamma=" << gamma;
  if (!calc_phi)
    o << "  phi=" << phi;
  if (lambda != NA)
    o << "  lambda=" << lambda;
  if (tox != NA)
    o << "  tox=" << tox;
  if (nsub != NA)
    o << "  nsub=" << nsub/(ICM2M3);
  if (nss != 0.0 || nsub != NA)
    o << "  nss=" << nss/(ICM2M2);
  if (xj != NA)
    o << "  xj=" << xj;
  o << "  ld=" << ld;
  o << "  uo=" << uo/(CM2M2);
  o << "  tpg=" << tpg;
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::print_calculated(OMSTREAM& o)const
{
  MODEL_MOS_BASE::print_calculated(o);
  if (calc_vto)
    o << "* vto=" << vto/((static_cast<double>(polarity)));
  if (calc_gamma)
    o << "* gamma=" << gamma;
  if (calc_phi)
    o << "* phi=" << phi;
  if (true)
    o << "* cox=" << cox;
}
/*--------------------------------------------------------------------------*/
void MODEL_MOS123::tr_eval(COMPONENT*)const
{
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
