/*$Id: d_diode.h,v 18.11 2000/08/30 05:19:43 al Exp $ -*- C++ -*-
 * data structures and defaults for diode model.
 */
#ifndef D_DIODE_H
#define D_DIODE_H
#include "e_subckt.h"
#include "e_model.h"
/*--------------------------------------------------------------------------*/
class DEV_DIODE;		/* this file */
class DIODE_COMMON;
class MODEL_DIODE;
class EVAL_DIODE_Yj;
class EVAL_DIODE_Cj;
/*--------------------------------------------------------------------------*/
class DEV_ADMITTANCE;		/* external */
class DEV_CAPACITANCE;
class SDP_MOS_BASE;
class MOS_COMMON;
/*--------------------------------------------------------------------------*/
enum region_t {INITOFF=-2, REVERSE=-1, UNKNOWN=0, FORWARD=1};
/*--------------------------------------------------------------------------*/
class DEV_DIODE : public BASE_SUBCKT {
  friend class DEV_MOS;
  friend class EVAL_DIODE_Yj;
  friend class EVAL_DIODE_Cj;
private:
  explicit DEV_DIODE(const DEV_DIODE& p);
public:
  explicit DEV_DIODE();
           ~DEV_DIODE()		{--_count;}
private: // override virtual
  char	   id_letter()const	{return 'D';}
  const char* dev_type()const	{return "diode";}
  int	   numnodes()const	{return 2;}
  CARD*	   clone()const		{untested(); return new DEV_DIODE(*this);}
  void	   parse(CS&);
  void	   print(OMSTREAM&,int)const;
  double   tr_probe_num(CS&)const;
  void	   expand();
public:
  static int count()		{return _count;}
private:
  region_t _region;	/* fwd, reverse, unknown */
  double   _isat;	/* is adjusted for temp, etc. */
  double   _gd;		/* conductance to pass to capacitor */
  DEV_ADMITTANCE*  _Yj;	/* subckt elements, for probe */
  DEV_CAPACITANCE* _Cj;
  static int _count;
};
/*--------------------------------------------------------------------------*/
class DIODE_COMMON : public COMPONENT_COMMON {
public:
  explicit DIODE_COMMON(int c=0);
  explicit DIODE_COMMON(const DIODE_COMMON& p, int c=0);
	   ~DIODE_COMMON()	{--_count;}
  void	   parse(CS&);
  void	   print(OMSTREAM&)const;
  void	   expand();
  const char* name()const	{untested(); return "diode";}

  double   is;		/* saturation current */
  double   rs;		/* series resistance */
  double   cj;		/* zero bias jct capacitance */
  double   cjsw;	/* zero bias sidewall capacitance */
  double   area;	/* area factor */
  double   perim;	/* perimeter factor */
  double   gparallel;	/* parallel conductance */
  double   ic;		/* initial voltage */
  bool	   off;		/* flag: assume reverse biased */
  struct {
    unsigned is:1,
	     rs:1,
	     cj:1,
	     cjsw:1,
	     gparallel:1;
  } calc;
  static int count()		{return _count;}
private:
  static int _count;
};
/*--------------------------------------------------------------------------*/
class MODEL_DIODE : public MODEL_CARD {
friend class DEV_DIODE;
friend class DIODE_COMMON;
friend class EVAL_DIODE_Yj;
friend class EVAL_DIODE_Cj;
protected:
  explicit MODEL_DIODE(const MODEL_DIODE& p) :MODEL_CARD(p) {unreachable();}
public:
  explicit	MODEL_DIODE();
		~MODEL_DIODE()	{--_count;}
private: // override virtual
  bool          parse_front(CS&);
  void          parse_params(CS&);
  void          post_parse();
  void          print_front(OMSTREAM& o)const {o << "  d";}
  void          print_params(OMSTREAM&)const;
  void          print_calculated(OMSTREAM&)const {}
public:
  static int	count()		{return _count;}
protected:
  double   js;	/* is  *//* saturation current (per area) */
  double   rs;		 /* ohmic resistance (per area) */
  double   n_factor;	 /* emission coefficient */
  double   tt;		 /* transit time */
  double   cjo;	/* cj  *//* zero-bias jct capacitance (per area) */
  double   pb;	/* vj  *//* junction potential */
  double   mj;	/* m   *//* grading coefficient */
  double   eg;		 /* activation energy */
  double   xti;		 /* saturation-current temp. exp. */
  double   kf;		 /* flicker noise coefficient */
  double   af;		 /* flicker noise exponent */
  double   fc;		 /* coef for fwd bis depl cap formula */
  double   bv;		 /* reverse breakdown voltage */
  double   ibv;		 /* current at reverse breakdown */
   			 /* non-spice extensions */
  double   cjsw;	 /* zero bias sidewall cap (per perim.) */
  double   pbsw;	 /* sidewall junction potential */
  double   mjsw;	 /* sidewall grading coefficient */
  double   gparallel;	 /* parallel conductance */
  int	   flags;
  int	   mos_level;
private:
  static int _count;
  enum {USE_OPT = 0x8000};
};
/*--------------------------------------------------------------------------*/
class EVAL_DIODE_Yj : public COMPONENT_COMMON {
private:
  explicit EVAL_DIODE_Yj(const EVAL_DIODE_Yj& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_DIODE_Yj(int c=0)	:COMPONENT_COMMON(c) {}
  const char* name()const		{untested(); return "EVAL_DIODE_Yj";}
  void	   tr_eval(ELEMENT*d)const;
  bool	   has_tr_eval()const		{return true;}
  bool	   has_ac_eval()const		{return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_DIODE_Cj : public COMPONENT_COMMON {
private:
  explicit EVAL_DIODE_Cj(const EVAL_DIODE_Cj& p) 
    :COMPONENT_COMMON(p) {unreachable();}
public:
  explicit EVAL_DIODE_Cj(int c=0)	:COMPONENT_COMMON(c) {}
  const char* name()const		{untested(); return "EVAL_DIODE_Cj";}
  void	   tr_eval(ELEMENT*d)const;
  bool	   has_tr_eval()const		{return true;}
  bool	   has_ac_eval()const		{return false;}
};
/*--------------------------------------------------------------------------*/
enum polarity_t {pP = -1, pN = 1};
/*--------------------------------------------------------------------------*/
class SDP_MMB
  :public SDP_CARD{
public:
  explicit SDP_MMB(const COMPONENT_COMMON* c) :SDP_CARD(c) {}
};
/*--------------------------------------------------------------------------*/
class MODEL_MMB
  :public MODEL_DIODE {
public:
  explicit MODEL_MMB() :MODEL_DIODE() {}
public:
  polarity_t polarity;	/* N or P channel */
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
