/*$Id: c_list.cc,v 17.10 2000/04/04 06:30:02 al Exp $ -*- C++ -*-
 * list and save commands.
 * save is list with direction to file
 */
#include "ap.h"
#include "e_card.h"
#include "c_comand.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::list(CS&);
//	void	CMD::save(CS&);
static	void	list_save(CS&, OMSTREAM);
/*--------------------------------------------------------------------------*/
extern CONST std::string head;
/*--------------------------------------------------------------------------*/
void CMD::list(CS& cmd)
{
  list_save(cmd, IO::mstdout);
}
/*--------------------------------------------------------------------------*/
void CMD::save(CS& cmd)
{
  cmd.reset();			/* back up to beginning of input line */
  OMSTREAM out = IO::mstdout;
  list_save(cmd, *outset(cmd,&out));
}
/*--------------------------------------------------------------------------*/
static void list_save(CS& cmd, OMSTREAM out)
{
  switch (ENV::run_mode){
  case rIGNORE:
  case rPRESET:
    /* do nothing */
    return;
  case rINTERACTIVE:
  case rSCRIPT:
  case rBATCH:
    /* keep going */
    break;
  }

  (out & ~IO::mstdout) << head << '\n';

  {if (cmd.end()){			/* no args: list all		    */
    for (CARD_LIST::const_iterator
	 ci=CARD_LIST::card_list.begin();ci!=CARD_LIST::card_list.end();++ci){
      (**ci).print(out, false);
    }
  }else{				/* some args: be selective	    */
    int arg1 = cmd.cursor();
    CARD_LIST::fat_iterator ci = findbranch(cmd, &CARD_LIST::card_list);
    if (ci.isend()){
      cmd.warn(bERROR, "can't find");
    }
    
    {if (cmd.match('-')){		/* there is a dash:  a range	    */
      cmd.skip();
      CARD_LIST::fat_iterator stop = ci;
      stop = findbranch(cmd, ++stop);
      if (stop.isend()){
	cmd.check(bERROR, "can't find");
	do {			// else go to the end
	  (**ci).print(out, false);
	} while (++ci != stop);
      }else{
	do {
	  (**ci).print(out, false);
	} while (ci++ != stop); // note subtle difference
      }
    }else{				/* no dash: a list		    */
      do {				/* each arg			    */
	int next = cmd.cursor();
	do {				/* all that match this arg	    */
	  (**ci).print(out, true);
	  cmd.reset(arg1);
	  assert(!ci.isend());
	  ci = findbranch(cmd, ++ci); // next match
	} while (!ci.isend());
	cmd.reset(arg1 = next);
	ci = findbranch(cmd, &CARD_LIST::card_list); // next arg
      } while (!ci.isend());
    }}
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
