/*$Id: c_file.cc,v 18.4 2000/07/09 05:58:31 al Exp $ -*- C++ -*-
 * log and > commands
 * log == commands log to a file
 * >   == all output to a file (redirect stdout)
 * bare command closes the file
 */
#include "io_.h"
#include "declare.h"	/* pllocate */
#include "ap.h"
#include "c_comand.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::logger(CS&);
//	void	CMD::file(CS&);
	char*	getcmd(const char*,char*,int);
/*--------------------------------------------------------------------------*/
static OMSTREAM mout;		/* > file bitmap		*/
static OMSTREAM mlog;		/* log file bitmap		*/
/*--------------------------------------------------------------------------*/
/* cmd_log: "log" command processing
 * open a file for logging (history)
 * arg is name of file
 * no arg closes the one most recently opened
 * the file will contain a list of commands executed, for use by "<"
 * multiple files can be open, they are nested, output to all.
 */
void CMD::logger(CS& cmd)
{
  untested();
  static std::list<FILE*> filestack;

  {if (cmd.more()){			/* a file name .. open it */
      const char *access = "w";
      while (cmd.match('>')){
	access = "a";
	cmd.skip();
	cmd.skipbl();
      }
      FILE* newfile = xopen(cmd,"",access);
      if (newfile){
        filestack.push_back(newfile);
	mlog |= OMSTREAM(newfile);
      }
  }else{				/* empty command -- close a file */
    {if (filestack.empty()){
      error(bWARNING, "no files open\n");
    }else{
      FILE* oldfile = filestack.back();
      filestack.pop_back();
      mlog &= ~(OMSTREAM(oldfile));
      fclose(oldfile);
    }}
  }}
}
/*--------------------------------------------------------------------------*/
/* cmd_file: ">" command processing
 * open a file for all output
 * the file will contain a copy of all screen output.
 * arg is name of file
 * no arg closes it
 * the file will contain all that would go to stdout
 */
void CMD::file(CS& cmd)
{
  untested();
  static std::list<FILE*> filestack;
  
  {if (cmd.more()){			/* a file name .. open it */
    const char* access = "w";
    while (cmd.match('>')){
      access = "a";
      cmd.skip();
      cmd.skipbl();
    }
    FILE* newfile = xopen(cmd,"",access);
    if (newfile){
      filestack.push_back(newfile);
      mout        |= OMSTREAM(newfile);
      IO::mstdout |= OMSTREAM(newfile);
    }
  }else{				/* empty command -- close a file */
    {if (filestack.empty()){
      error(bWARNING, "no files open\n");
    }else{
      FILE* oldfile = filestack.back();
      filestack.pop_back();
      mout        &= ~(OMSTREAM(oldfile));
      IO::mstdout &= ~(OMSTREAM(oldfile));
      fclose(oldfile);
    }}
  }}
}
/*--------------------------------------------------------------------------*/
/* getcmd: get a command.
 * if "fin" is stdin, display a prompt first.
 * Also, actually do logging, echo, etc.
 */
char *getcmd(const char *prompt, char *buffer, int buflen)
{
  pllocate();
  IO::mstdout << prompt << " \b";	/* prompt & flush buffer */
  if (!fgets(buffer, buflen, stdin)){
    error(bEXIT, "EOF on stdin\n");
  }
  (IO::mstdout&~mout) << '\r';		/* reset col counter */
  trim(buffer);
  (mlog | mout) << buffer << '\n';
  return buffer;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
