/*$Id: bm_value.cc,v 18.7 2000/07/25 16:07:21 al Exp $ -*- C++ -*-
 * behavioral modeling simple value
 * used with tc, etc, and conditionals
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
EVAL_BM_VALUE::EVAL_BM_VALUE(int c)
  :EVAL_BM_ACTION_BASE(c),
   _value(0)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_VALUE::EVAL_BM_VALUE(const EVAL_BM_VALUE& p)
  :EVAL_BM_ACTION_BASE(p),
   _value(p._value)
{
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_VALUE::parse(CS& cmd)
{
  int here = cmd.cursor();
  do{
    int paren = cmd.skiplparen();
    double value=NOT_VALID;
    cmd >> value;
    if (cmd.gotit(here)){
      _value = value;
    }
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck(&here));
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_VALUE::print(OMSTREAM& where)const
{
  where << "  " << _value;
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_VALUE::tr_eval(ELEMENT* d)const
{
  tr_finish_tdv(d, _value);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
