/*$Id: bm_tanh.cc,v 18.7 2000/07/25 16:07:21 al Exp $ -*- C++ -*-
 * behavioral modeling hyperbolic tangent
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
EVAL_BM_TANH::EVAL_BM_TANH(int c)
  :EVAL_BM_ACTION_BASE(c),
   _gain(NOT_INPUT),
   _limit(NOT_INPUT)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_TANH::EVAL_BM_TANH(const EVAL_BM_TANH& p)
  :EVAL_BM_ACTION_BASE(p),
   _gain(p._gain),
   _limit(p._limit)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_TANH::parse(CS& cmd)
{
  int here = cmd.cursor();
  do{
    double gain=NOT_VALID;
    double limit=NOT_VALID;
    cmd >> gain >> limit;
    {if (cmd.gotit(here)){
      _gain  = gain;
      _limit = limit;
    }else{
      get(cmd, "Gain",	&_gain);
      get(cmd, "Limit",	&_limit);
      parse_base(cmd);
    }}
  }while (cmd.more() && !cmd.stuck(&here));
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_TANH::print(OMSTREAM& where)const
{
  where << "  " << name()
	<< "  gain=" << _gain
	<< "  limit="<< _limit;
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_TANH::tr_eval(ELEMENT* d)const
{
  double x = ioffset(d->_y0.x);
  double aa = x * _gain/_limit;
  double cosine = cosh(aa);
  double f1 = _gain / (cosine*cosine);
  double f0 = _limit * tanh(aa);
  d->_y0 = FPOLY1(x, f0, f1);
  tr_final_adjust(&(d->_y0), d->f_is_value());
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
