/*$Id: bm_sin.cc,v 18.7 2000/07/25 16:07:21 al Exp $ -*- C++ -*-
 * SPICE compatible SIN
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
const double _default_offset	(0);
const double _default_amplitude	(1);
const double _default_frequency (NOT_INPUT);
const double _default_delay	(0);
const double _default_damping	(0);
/*--------------------------------------------------------------------------*/
EVAL_BM_SIN::EVAL_BM_SIN(int c)
  :EVAL_BM_ACTION_BASE(c),
   _offset(_default_offset),
   _amplitude(_default_amplitude),
   _frequency(_default_frequency),
   _delay(_default_delay),
   _damping(_default_damping),
   _end(NOT_VALID)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_SIN::EVAL_BM_SIN(const EVAL_BM_SIN& p)
  :EVAL_BM_ACTION_BASE(p),
   _offset(p._offset),
   _amplitude(p._amplitude),
   _frequency(p._frequency),
   _delay(p._delay),
   _damping(p._damping),
   _end(NOT_VALID)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_SIN::parse(CS& cmd)
{
  int here = cmd.cursor();
  do{
    int paren = cmd.skiplparen();
    double* i;
    for (i = &_offset;  i < &_end;  ++i){
      double value=NOT_VALID;
      cmd >> value;
      if (cmd.stuck(&here)){
	break;
      }
      *i = value;
    }
    assert(i <= &_end);
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    get(cmd, "Offset",	 &_offset);
    get(cmd, "Amplitude",&_amplitude);
    get(cmd, "Frequency",&_frequency);
    get(cmd, "DElay",	 &_delay);
    get(cmd, "DAmping",	 &_damping);
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck(&here));
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_SIN::print(OMSTREAM& where)const
{
  where << "  " << name()
	<< "  offset="	 << _offset
	<< "  amplitude="<< _amplitude
	<< "  frequency="<< _frequency
	<< "  delay="	 << _delay
	<< "  damping="	 << _damping;
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_SIN::tr_eval(ELEMENT* d)const
{
  double reltime = ioffset(SIM::time0);
  double ev = _offset;
  if (reltime > _delay){
    double x = _amplitude * fixzero(sin(kPIx2*_frequency*(reltime-_delay)),1.);
    if (_damping != 0.){
      x *= Exp(-(reltime-_delay)*_damping);
    }
    ev += x;
  }
  tr_finish_tdv(d, ev);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
