/*$Id: bm_fit.cc,v 18.7 2000/07/25 16:07:21 al Exp $ -*- C++ -*-
 * cubic spline bm function
 */
#include "ap.h"
#include "m_interp.h"
#include "m_spline.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
const int _default_order (3);
const double _default_below (NOT_INPUT);
const double _default_above (NOT_INPUT);
/*--------------------------------------------------------------------------*/
EVAL_BM_FIT::EVAL_BM_FIT(int c)
  :EVAL_BM_ACTION_BASE(c),
   _order(_default_order),
   _below(_default_below),
   _above(_default_above),
   _table(),
   _s(0)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_FIT::EVAL_BM_FIT(const EVAL_BM_FIT& p)
  :EVAL_BM_ACTION_BASE(p),
   _order(p._order),
   _below(p._below),
   _above(p._above),
   _table(p._table),
   _s(0)
{
  untested();
}
/*--------------------------------------------------------------------------*/
EVAL_BM_FIT::~EVAL_BM_FIT()
{
  delete _s;
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_FIT::parse(CS& cmd)
{
  delete _s;
  _s = 0;
  int here = cmd.cursor();
  do{
    int paren = cmd.skiplparen();
    for (;;){
      double key  =NOT_VALID;
      double value=NOT_VALID;
      cmd >> key >> value;
      if (cmd.stuck(&here)){
	break;
      }
      std::pair<double,double> p(key,value);
      _table.push_back(p);
    }
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    get(cmd, "Order", &_order);
    get(cmd, "Below", &_below);
    get(cmd, "Above", &_above);
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck(&here));
  parse_base_finish();
  switch (_order){
  default:
    untested();
    error(bDANGER, "bad order\n");
    _order = 3;
    // fall through
  case 3:
    _s = new SPLINE(_table, _below, _above);
    break;
  case 1: 
    assert(!_s);
    break;
  }
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_FIT::print(OMSTREAM& where)const
{
  where << "  " << name() << '(';
  for (std::vector<std::pair<double,double> >::const_iterator
	 p = _table.begin();  p != _table.end();  ++p){
    where << "  " << p->first << ',' << p->second;
  }
  where << ')';
  print_base(where);
  where << "  order=" << _order;
  if (_below != NOT_INPUT) {where << "  below=" << _below;}
  if (_above != NOT_INPUT) {where << "  above=" << _above;}
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_FIT::tr_eval(ELEMENT* d)const
{
  switch (_order){
  case 3:
    d->_y0 = _s->at(d->_y0.x);
    break;
  case 1:
    d->_y0 = interpolate(_table.begin(), _table.end(), ioffset(d->_y0.x),
			 _below, _above);
    break;
  default:
    unreachable();
  }
  tr_final_adjust(&(d->_y0), d->f_is_value());
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
