/*$Id: bm.h,v 18.8 2000/07/26 09:26:27 al Exp $ -*- C++ -*-
 * behavioral modeling base
 */
#ifndef E_BM_H
#define E_BM_H
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
class SPLINE;
/*--------------------------------------------------------------------------*/
class EVAL_BM_BASE : public COMPONENT_COMMON {
protected:
  explicit	EVAL_BM_BASE(int c=0) :COMPONENT_COMMON(c) {}
  explicit	EVAL_BM_BASE(const EVAL_BM_BASE& p)
    :COMPONENT_COMMON(p) {}
private: // override virtual
  bool		has_tr_eval()const	{return true;}
  bool		has_ac_eval()const	{return true;}
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_ACTION_BASE : public EVAL_BM_BASE {
protected:
  double _bandwidth;
  double _delay;
  double _phase;
  double _ooffset;
  double _ioffset;
  double _scale;
  double _tc1;
  double _tc2;
  double _ic;
  bool   _needs_ac_eval;
  bool	 _has_ext_args;
protected:
  explicit	EVAL_BM_ACTION_BASE(int c=0);
  explicit	EVAL_BM_ACTION_BASE(const EVAL_BM_ACTION_BASE& p);
		~EVAL_BM_ACTION_BASE() {}
  void		parse_base(CS&);
  void		parse_base_finish();
  void		print_base(OMSTREAM&)const;
  double	temp_adjust()const;
  void		tr_final_adjust(FPOLY1* y, bool f_is_value)const;
  void		tr_finish_tdv(ELEMENT* d, double val)const;
  void		ac_final_adjust(COMPLEX* y)const;
  void		ac_final_adjust_with_temp(COMPLEX* y)const;
  double	ioffset(double x)const	{return x + _ioffset;}	
public: // override virtual
  void		ac_eval(ELEMENT* d)const;
  virtual bool	ac_too()const = 0;
private: // override virtual
  bool		has_ac_eval()const	{return true;}
public:
  bool		has_ext_args()const	{return _has_ext_args;}
  static EVAL_BM_ACTION_BASE* parse_func_type(CS&);
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_COND : public EVAL_BM_BASE {
private:
  const COMPONENT_COMMON* _func[sCOUNT];
  bool _set[sCOUNT];
public:
  explicit	EVAL_BM_COND(int c=0);
protected:
  explicit	EVAL_BM_COND(const EVAL_BM_COND& p);
		~EVAL_BM_COND();
private: // override virtual
  const char*	name()const		{unreachable(); return "????";}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const
		    {assert(_func[SIM::mode]); _func[SIM::mode]->tr_eval(d);}
  void		ac_eval(ELEMENT*d)const
		    {assert(_func[sAC]); _func[sAC]->ac_eval(d);}
  const COMPONENT_COMMON* deflate()const;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
class EVAL_BM_COMPLEX : public EVAL_BM_ACTION_BASE {
private:
  COMPLEX _value;
public:
  explicit      EVAL_BM_COMPLEX(int c=0);
  explicit	EVAL_BM_COMPLEX(const EVAL_BM_COMPLEX& p);
		~EVAL_BM_COMPLEX()	{}
private: // override virtual
  const char*	name()const		{return "COMPLEX";}
  bool		ac_too()const		{return true;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*)const;
  void		ac_eval(ELEMENT*)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_EXP : public EVAL_BM_ACTION_BASE {
private:
  double _iv;	 // initial value
  double _pv;	 // pulsed value
  double _td1;   // rise delay
  double _tau1;  // rise time constant
  double _td2;   // fall delay
  double _tau2;  // fall time constant
  double _period;// repeat period
  double _end;	 // marks the end of the list
public:
  explicit      EVAL_BM_EXP(int c=0);
  explicit	EVAL_BM_EXP(const EVAL_BM_EXP& p);
		~EVAL_BM_EXP()		{}
private: // override vitrual
  const char*	name()const		{return "EXP";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_FIT : public EVAL_BM_ACTION_BASE {
private:
  int _order;
  double _below;
  double _above;
  std::vector<std::pair<double,double> > _table;
  SPLINE* _s;
public:
  explicit      EVAL_BM_FIT(int c=0);
  explicit	EVAL_BM_FIT(const EVAL_BM_FIT& p);
		~EVAL_BM_FIT();
private: // override virtual
  const char*	name()const		{return "FIT";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_GENERATOR : public EVAL_BM_ACTION_BASE {
public:
  explicit      EVAL_BM_GENERATOR(int c=0);
  explicit	EVAL_BM_GENERATOR(const EVAL_BM_GENERATOR& p);
		~EVAL_BM_GENERATOR()	{}
private: // override virtual
  const char*	name()const		{return "GENERATOR";}
  bool		ac_too()const		{return true;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
  void		ac_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_POLY : public EVAL_BM_ACTION_BASE {
private:
  double _max;
  double _min;
  bool   _abs;
  std::vector<double> _c;
public:
  explicit      EVAL_BM_POLY(int c=0);
  explicit	EVAL_BM_POLY(const EVAL_BM_POLY& p);
		~EVAL_BM_POLY()		{}
private: // override vitrual
  const char*	name()const		{return "POLY";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_POSY : public EVAL_BM_ACTION_BASE {
private:
  double _max;
  double _min;
  bool   _abs;
  std::vector<std::pair<double,double> > _table;
public:
  explicit      EVAL_BM_POSY(int c=0);
  explicit	EVAL_BM_POSY(const EVAL_BM_POSY& p);
		~EVAL_BM_POSY()		{}
private: // override vitrual
  const char*	name()const		{return "POSY";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_PULSE : public EVAL_BM_ACTION_BASE {
private:
  double _iv;
  double _pv;
  double _delay;
  double _rise;
  double _fall;
  double _width;
  double _period;
  double _end;
public:
  explicit      EVAL_BM_PULSE(int c=0);
  explicit	EVAL_BM_PULSE(const EVAL_BM_PULSE& p);
		~EVAL_BM_PULSE()	{}
private: // override vitrual
  const char*	name()const		{return "PULSE";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_PWL : public EVAL_BM_ACTION_BASE {
private:
  double _delta;
  int    _smooth;
  std::vector<std::pair<double,double> > _table;
public:
  explicit      EVAL_BM_PWL(int c=0);
  explicit	EVAL_BM_PWL(const EVAL_BM_PWL& p);
		~EVAL_BM_PWL()		{}
private: // override virtual
  const char*	name()const		{return "PWL";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_SFFM : public EVAL_BM_ACTION_BASE {
private:
  double _offset;
  double _amplitude;
  double _carrier;
  double _modindex;
  double _signal;
  double _end;
public:
  explicit      EVAL_BM_SFFM(int c=0);
  explicit	EVAL_BM_SFFM(const EVAL_BM_SFFM& p);
		~EVAL_BM_SFFM()		{}
private: // override vitrual
  const char*	name()const		{return "SFFM";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_SIN : public EVAL_BM_ACTION_BASE {
private:
  double _offset;
  double _amplitude;
  double _frequency;
  double _delay;
  double _damping;
  double _end;
public:
  explicit      EVAL_BM_SIN(int c=0);
  explicit	EVAL_BM_SIN(const EVAL_BM_SIN& p);
		~EVAL_BM_SIN()		{}
private: // override vitrual
  const char*	name()const		{return "SIN";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_TANH : public EVAL_BM_ACTION_BASE {
private:
  double _gain;
  double _limit;
public:
  explicit      EVAL_BM_TANH(int c=0);
  explicit	EVAL_BM_TANH(const EVAL_BM_TANH& p);
		~EVAL_BM_TANH()		{}
private: // override virtual
  const char*	name()const		{return "TANH";}
  bool		ac_too()const		{return false;}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_VALUE : public EVAL_BM_ACTION_BASE {
private:
  double _value;
public:
  explicit      EVAL_BM_VALUE(int c=0);
  explicit	EVAL_BM_VALUE(const EVAL_BM_VALUE& p);
		~EVAL_BM_VALUE()	{}
  double	value()const		{return _value;}
private: // override virtual
  const char*	name()const		{return "VALUE";}
  bool		ac_too()const		{return false;}
  void		print(OMSTREAM&)const;
  void		tr_eval(ELEMENT*d)const;
public:
  void		parse(CS&);
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
