/*$Id: ap_match.cc,v 18.9 2000/08/16 08:11:43 al Exp $ -*- C++ -*-
 * string compare
 */
#include "ap.h"
/*--------------------------------------------------------------------------*/
//	CS&	CS::pmatch(const std::string&);
//	CS&	CS::icmatch(const std::string&);
//	CS&	CS::pscan(const std::string&);
/*--------------------------------------------------------------------------*/
/* pmatch = partial match
 * compares characters until end of first string
 * any non-alpha character may be a terminator
 * Characters in reference string in UPPER case must match.
 * Always requires at least one character to match.
 */
CS& CS::pmatch(const std::string& s)
{
  int start = cursor();
  skipbl();
  int tokenstart = cursor();

  const char* str2 = s.c_str();
  while (*str2 && tolower(peek()) == tolower(*str2)) { // as far as you can
    skip();
    ++str2;
  }
  // something didn't match -- let's see what and why
  {if (strcmp(str2,"$$")==0) { // stop marker in reference -- accept
    skipcom();
    _ok = true;
  }else if (cursor() == tokenstart// didn't move
	    || is_alpha()	  // more letters in the string being tested
    	    || isspace(*str2)
    	    || isupper(*str2)	  // more caps (must match) in the reference
    	    || isdigit(*str2)	  // numbers (must match) in the reference
    	    || ispunct(*str2)) {  // punctuation (must match) in the reference
    reset(start);	// back up (don't consume)
    _ok = false;	// reject
  }else{	    // reached natural end, accept
    skipcom();
    _ok = true;
  }}
  return *this;
}
/*--------------------------------------------------------------------------*/
/* icmatch = ignore-case match
 * match of full string, ignoring case.
 */
CS& CS::icmatch(const std::string& s)
{
  int start = cursor();
  skipbl();

  const char* str2 = s.c_str();
  while (*str2 && tolower(peek()) == tolower(*str2)) { // as far as you can
    skip();
    ++str2;
  }
  {if (*str2 == '\0') {
    skipcom();
    _ok = true;
  }else{
    reset(start);
    _ok = false;
  }}
  return *this;
}
/*--------------------------------------------------------------------------*/
CS& CS::pscan(const std::string& s)
{
  int start = cursor();
  for (;;) {
    {if (pmatch(s)) {	// found it
      _ok = true;
      break;
    }else if (!more()) {// ran out
      reset(start);
      _ok = false;
      break;
    }else{		// skip and try again
      skiparg();
    }}
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
