/*$Id: ap.h,v 18.9 2000/08/16 08:11:43 al Exp $  -*- C++ -*-
 * stuff for the "ap" family of parsing functions
 */
#ifndef AP_H
#define AP_H
#include "md.h"
/*--------------------------------------------------------------------------*/
enum AP_MOD{
  mNONE,	/* nothing special */
  mSCALE,	/* scale it after reading */
  mOFFSET,	/* add an offset */
  mINVERT,	/* save 1 / the number */
  mPOSITIVE,	/* store absolute value */
  mOCTAL,	/* read the number in octal */
  mHEX		/* read the number in hex */
};
  
class CS {
private:
  char* _cmd;
  int  _cnt;
  bool _ok;
  int  _length;
public:
  // construction, destruction, and re-construction
  explicit    CS(const std::string& s,int i=0);
  explicit    CS(const CS& p);
  CS&	      operator=(const std::string& s);
  CS&	      operator=(const CS& p);
	      ~CS()		{delete [] _cmd;}

  // status - non-consuming
  int	      cursor()const	{return _cnt;}
  bool        stuck(int* last)	{bool ok=*last<_cnt; *last=_cnt; return !ok;}
  bool        gotit(int last)	{return last<_cnt;}
	    operator bool()const{return _ok;}

  // status - may consume whitespace only
  bool	      ns_more()		{return _cmd[_cnt]!='\0';}
  bool	      more()		{skipbl(); return _cmd[_cnt]!='\0';}
  bool	      end()		{skipbl(); return _cmd[_cnt]=='\0';}

  // get -- non-consuming
  const char* fullstring()const	{return _cmd;}
  const char* tail()const	{return &_cmd[_cnt];}
  char	      peek()const	{return _cmd[_cnt];}

  // control
  CS&	      reset(int c=0)	{_cnt=c; _ok=true; return *this;}

  // exception handling (ap_error.cc) non-consuming
  CS&	      check(int, const std::string&);
  CS&	      warn(int, int, const std::string&);
  CS&         warn(int i, const std::string& s)	{return warn(i,cursor(), s);}

  // string matching (ap_match.cc) possibly consuming, sets _ok
  CS&	      pmatch(const std::string&);	// partial match
  CS&	      icmatch(const std::string&);	// ignore case match
  CS&	      pscan(const std::string&);

  // character tests - non-consuming, no _ok
  bool	      match(char c)const{return (_cmd[_cnt]==c);}
  bool	      match1(const std::string& c)const
			{return _cmd[_cnt]&&strchr(c.c_str(),_cmd[_cnt]);}
  bool	      is_xdigit()const
		{untested(); return (match1("0123456789abcdefABCDEF"));}
  bool	      is_digit()const	{return (match1("0123456789"));}
  bool	      is_pfloat()const	{return (match1(".0123456789"));}
  bool	      is_float()const	{return (match1("+-.0123456789"));}
  bool	      is_argsym()const	{return (match1("*?$%_&@"));}
  bool	      is_alpha()const	{return !!isalpha(toascii(_cmd[_cnt]));}
  bool	      is_term(const std::string& t = ",=(){};")
	{char c=peek(); return (c=='\0' || isspace(c) || match1(t));}

  // conversions (ap_convert.cc) always consuming
  char	      ctoc()			{return _cmd[_cnt++];}
  void        ctostr(char*,int,const std::string&);	// ap_ctos.cc
  std::string ctos(const std::string& term=",=(){};");

  // conversions (ap_convert.cc) consumes if successful, sets _ok
  double      ctof();					// ap_ctof.cc
  int	      ctoi();					// ap_ctoi.cc
  unsigned    ctou();
  int	      ctoo();
  int	      ctox();
  double      ctopf()			{return abs(ctof());}
  CS&	      operator>>(char&x)	{x=ctoc();return *this;}
  CS&         operator>>(int&x)		{x=ctoi();return *this;}
  CS&         operator>>(unsigned&x)	{untested(); x=ctou();return *this;}
  CS&         operator>>(double&x)	{x=ctof();return *this;}
  CS&	      operator>>(std::string&x) {x=ctos();return *this;}

  // skip (ap_skip.cc) possibly consuming, sets _ok
  CS&	      skip(int c=1)	{_cnt+=c; _ok=_cnt<=_length; return *this;}
  CS&	      skipbl();
  CS&	      skip1b(const std::string&);
  CS&	      skip1(const std::string&);
  CS&	      skiparg();
  CS&	      skipto(const std::string&);
  CS&	      skipto(char);
  CS&	      skipcom()		{return skip1b(",=");}
  CS&	      skiplparen()	{return skip1b("([");}
  CS&	      skiprparen()	{return skip1b(")]");}
  CS&	      skipequal()	{return skip1b("=");}
};	
/*--------------------------------------------------------------------------*/
// these are non-member to provide a consistent interface,
// like the templates to follow
bool get(CS& cmd, const std::string&, bool*, AP_MOD=mNONE);
bool get(CS& cmd, const std::string&, int*,  AP_MOD=mNONE, int=0);
#ifdef BROKEN_TEMPLATE_OVERLOAD
bool get(CS& cmd, const std::string& key, double* val, AP_MOD=mNONE, double=0);
#else
bool get(CS& cmd, const std::string& key, double* val, AP_MOD, double=0);
#endif
/*--------------------------------------------------------------------------*/
#ifndef BROKEN_TEMPLATE_OVERLOAD
template <class T>
inline bool get(CS& cmd, const std::string& key, T* val)
{
  {if (cmd.pmatch(key)){
    cmd >> *val;
    return true;
  }else{
    return false;
  }}
}
#endif
/*--------------------------------------------------------------------------*/
template <class T>
inline bool set(CS& cmd, const std::string& key, T* val, T newval)
{
  {if (cmd.pmatch(key)){
    *val = newval;
    return true;
  }else{
    return false;
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
