/*$Id: mg_out_h.cc,v 17.23 2000/05/26 07:54:22 al Exp $ -*- C++ -*-
 */
#include <fstream>
#include "mg_.h"
/*--------------------------------------------------------------------------*/
static void make_header(std::ofstream& out, const File& in, 
			const std::string& dump_name)
{
  out << in.head()
      << "/* This file is automatically generated. DO NOT EDIT */\n"
    "#ifndef " << to_upper(dump_name) << "_H_INCLUDED\n"
    "#define " << to_upper(dump_name) << "_H_INCLUDED\n"
      << in.h_headers()
      << "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_sdp(std::ofstream& out, const Model& m)
{
  out << "class SDP_" << m.name()
      << "\n  :public SDP_" << m.inherit()
      << "{\n"
    "public:\n"
    "  explicit SDP_" << m.name() << "(const COMPONENT_COMMON*);\n";
  out << "public:\n";
  Parameter_List::const_iterator p = m.size_dependent().raw().begin();
  for (;;) {
    if (p == m.size_dependent().raw().end()) {
      p = m.size_dependent().calculated().begin();
    }
    if (p == m.size_dependent().calculated().end()) {
      break;
    }
    out << "  " << (**p).type() << " " << (**p).code_name() 
	<< ";\t// " << (**p).comment() << '\n';
    ++p;
  }
  out << "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_tdp(std::ofstream& out, const Model& m)
{
  out << "class TDP_" << m.name();
  if (!m.is_base()) {
    out << "\n  :public TDP_" << m.inherit();
  }
  out << "{\n"
    "public:\n"
    "  explicit TDP_"<< m.name() <<"(const DEV_" << m.root() << "*);\n"
    "public:\n";
  for (Parameter_List::const_iterator
	 p = m.temperature().calculated().begin();
       p != m.temperature().calculated().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name() 
	<< ";\t// " << (**p).comment() << '\n';
  }
  out << "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model(std::ofstream& out, const Model& m)
{
  out << "class MODEL_" << m.name() << "\n"
    "  :public MODEL_" << m.inherit() << "{\n"
    "public:\n"
    "  // using generated copy constructor, should be unreachable\n"
    "  explicit MODEL_" << m.name() << "();\n"
    "  ~MODEL_" << m.name() << "() {--_count;}\n"
    "public: // override virtual\n"
    "  bool          parse_front(CS&);\n"
    "  void          parse_params(CS&);\n"
    "  void          post_parse();\n"
    "  SDP_CARD* new_sdp(const COMPONENT_COMMON* c)const {return new SDP_"
      << m.name() << "(c);}\n"
    "  void          print_front(OMSTREAM&)const;\n"
    "  void          print_params(OMSTREAM&)const;\n"
    "  void          print_calculated(OMSTREAM&)const;\n"
    "  void          tr_eval(COMPONENT*)const;\n"
    "public: // not virtual\n"
    "  static int    count() {return _count;}\n"
    "public: // strictly internal\n";
  if (m.level() != "") {
    out << "  enum {LEVEL=" << m.level() <<"};\n";
  }
  out << "  static int _count;\n"
    "public: // input parameters\n";
  for (Parameter_List::const_iterator
	 p = m.size_dependent().raw().begin();
       p != m.size_dependent().raw().end(); ++p) {
    out << "  " << "SDP" << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }
  out << '\n';
  for (Parameter_List::const_iterator
	 p = m.independent().raw().begin();
       p != m.independent().raw().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }
  out << "public: // calculated parameters\n";
  for (Parameter_List::const_iterator
	 p = m.independent().calculated().begin();
       p != m.independent().calculated().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }
  out << "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "#endif\n";
}
/*--------------------------------------------------------------------------*/
void make_h_file(const File& in)
{
  std::string dump_name = in.name();
  dump_name.erase(dump_name.rfind(".model"));
  std::ofstream out((dump_name+".h").c_str());
  if (!out) {
    untested();
    os_error(dump_name);
  }
  dump_name.erase(dump_name.find("../"),3);

  make_header(out, in, dump_name);

  for (Model_List::const_iterator
	 m = in.models().begin();  m != in.models().end();  ++m) {
    make_sdp(out, **m);
    make_tdp(out, **m);
    make_model(out, **m);
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
