/*$Id: mg_out_cc.cc,v 18.17 2000/09/04 09:46:48 al Exp $ -*- C++ -*-
 */
#include <fstream>
#include "mg_.h"
/*--------------------------------------------------------------------------*/
static void make_final_adjust(std::ofstream& out, const Parameter& p)
{
  if (!(p.calculate().empty())) {
    out << "  " << p.code_name() << " = " << p.calculate() << ";\n";
  }
  if (!(p.final_default().empty())) {
    out << "  if (" << p.code_name() << " == NA) {\n"
      "    " << p.code_name() << " = " << p.final_default() << ";\n"
      "  }\n";
  }
  if (!(p.quiet_min().empty())) {
    out << "  " << p.code_name() << " = std::max(" 
	<< p.code_name() << ", " << p.quiet_min() << ");\n";
  }
  if (!(p.quiet_max().empty())) {
    out << "  " << p.code_name() << " = std::min(" 
	<< p.code_name() << ", " << p.quiet_max() << ");\n";
  }
}
/*--------------------------------------------------------------------------*/
static void make_final_adjust(std::ofstream& out, const Parameter_Block& b)
{
  out << b.code_front() << '\n';
  Parameter_List::const_iterator p = b.override().begin();
  for (;;) {
    if (p == b.override().end()) {
      p = b.raw().begin();
    }
    if (p == b.raw().end()) {
      p = b.calculated().begin();
    }
    if (p == b.calculated().end()) {
      break;
    }
    make_final_adjust(out, **p);
    ++p;
  }
  out << b.code();
}
/*--------------------------------------------------------------------------*/
static void make_header(std::ofstream& out, const File& in, 
			const std::string& dump_name)
{
  out << in.head()
      << "/* This file is automatically generated. DO NOT EDIT */\n"
      << in.cc_headers()
      << "#include \"ap.h\"\n"
    "#include \"" << dump_name << ".h\"\n"
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "const double NA(NOT_INPUT);\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_sdp_constructor(std::ofstream& out, const Model& m)
{
  out << "SDP_" << m.name() << "::SDP_" << m.name() 
      << "(const COMPONENT_COMMON* cc)\n"
    "  :SDP_" << m.inherit() << "(cc)\n"
    "{\n";
  if (!m.size_dependent().is_empty()) {
    out << "  assert(cc);\n"
      "  const " << m.root() << "_COMMON* c = prechecked_cast<const "
	<< m.root() << "_COMMON*>(cc);\n"
      "  assert(c);\n"
	<< "  const MODEL_" << m.name() 
	<< "* m = prechecked_cast<const MODEL_" 
	<< m.name() << "*>(c->model());\n"
      "  assert(m);\n"
	<< m.size_dependent().code_front();
    for (Parameter_List::const_iterator
	   p = m.size_dependent().override().begin();
	 p != m.size_dependent().override().end(); ++p) {
      make_final_adjust(out, **p);
    }
    for (Parameter_List::const_iterator
	   p = m.size_dependent().raw().begin();
	 p != m.size_dependent().raw().end(); ++p) {
      {if (!((**p).final_default().empty())) {
	out << "  " << (**p).code_name() 
	    << " = ((m->" << (**p).code_name() << ".nom() == NA)\n"
	  "    ? " << (**p).final_default() <<"\n"
	  "    : m->" << (**p).code_name() << "(L, W));\n";
      }else{
	out << "  " << (**p).code_name() << " = m->" << (**p).code_name()
	    << "(L, W);\n";
	make_final_adjust(out, **p);
      }}
    }
    for (Parameter_List::const_iterator
	   p = m.size_dependent().calculated().begin();
	 p != m.size_dependent().calculated().end(); ++p) {
      make_final_adjust(out, **p);
    }
    out << m.size_dependent().code();
  }
  
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_tdp_constructor(std::ofstream& out, const Model& m)
{
  out << "TDP_" << m.name() << "::TDP_" << m.name() 
      << "(const DEV_" << m.root() << '*';
  if (!m.is_base() || !m.temperature().is_empty()) {
    out << " d";
  }
  out << ")\n";
  if (!m.is_base()) {
    out << "  :TDP_" << m.inherit() << "(d)\n";
  }
  out << "{\n";
  if (!m.temperature().is_empty()) {
    out << "  assert(d);\n"
      "  const " << m.root() << "_COMMON* c = prechecked_cast<const " 
	<< m.root() << "_COMMON*>(d->common());\n"
      "  assert(c);\n"
      "  const SDP_" << m.name() << "* b = prechecked_cast<const SDP_" 
	<< m.name() << "*>(c->sdp);\n"
      "  assert(b);\n"
      "  const MODEL_" << m.name() << "* m = prechecked_cast<const MODEL_" 
	<< m.name() << "*>(c->model());\n"
      "  assert(m);\n";
    make_final_adjust(out, m.temperature());
  }

  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model_constructor(std::ofstream& out, const Model& m)
{

  out << "MODEL_" << m.name() << "::MODEL_" << m.name() << "()\n"
    "  :MODEL_" << m.inherit() << "()";

  Parameter_List::const_iterator p = m.size_dependent().raw().begin();
  for (;;) {
    if (p == m.size_dependent().raw().end()) {
      p = m.independent().raw().begin();
    }
    if (p == m.independent().raw().end()) {
      p = m.independent().calculated().begin();
    }
    if (p == m.independent().calculated().end()) {
      break;
    }
    {if (!((**p).default_val().empty())) {
      out << ",\n   " << (**p).code_name() << "("
	  << (**p).default_val() << ")";
    }else{
      out << ",\n   " << (**p).code_name() << "(NA)";
    }}
    ++p;
  }
  out << "\n{\n"
    "  ++_count;\n";
  for (Parameter_List::const_iterator
	 p = m.independent().override().begin();
       p != m.independent().override().end();
       ++p) {
    if (!((**p).final_default().empty())) {
      out << "  " << (**p).code_name() << " = NA;\n";
    }
    if (!((**p).default_val().empty())) {
      out << "  " << (**p).code_name() << " = " << (**p).default_val() <<";\n";
    }
  }
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_parse_front(std::ofstream& out, const Model& m)
{
  out << "bool MODEL_" << m.name() << "::parse_front(CS& cmd)\n"
    "{\n";
  {if (!m.key_list().is_empty()) {
    out << "  return ";
    Key_List::const_iterator k = m.key_list().begin();
    for (;;) {
      out << "set(cmd, \"" << (**k).name() << "\", &" << (**k).var() << ", " 
	  << (**k).value() << ")";
      ++k;
      if (k == m.key_list().end()){
	break;
      }
      out << "\n    || ";
    }
    {if (!m.is_base()) {
      out << "\n    || MODEL_" << m.inherit() << "::parse_front(cmd);\n";
    }else{
      out << ";\n";
    }}
  }else{
    if (!m.is_base()) {
      out << "  return MODEL_" << m.inherit() << "::parse_front(cmd);\n";
    }
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_get(std::ofstream& out, const Parameter& p,
		     const std::string& name)
{
  if (!(name.empty())) {
    out << "  get(cmd, \"" << name << "\", &" << p.code_name();
    {if (!(p.offset().empty())) {
      out << ", mOFFSET, " << p.offset() << ");\n";
    }else if (p.positive()) {
      out << ", mPOSITIVE);\n";
    }else if (!(p.scale().empty())) {
      out << ", mSCALE, " << p.scale() << ");\n";
    }else{
      out << ");\n";
    }}
  }
}
/*--------------------------------------------------------------------------*/
static void make_parse_params(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::parse_params(CS& cmd)\n{\n";
  Parameter_List::const_iterator p = m.independent().override().begin();
  for (;;) {
    if (p == m.independent().override().end()) {
      p = m.size_dependent().raw().begin();
    }
    if (p == m.size_dependent().raw().end()) {
      p = m.independent().raw().begin();
    }
    if (p == m.independent().raw().end()) {
      break;
    }
    make_get(out, **p, (**p).user_name());
    make_get(out, **p, (**p).alt_name());
    ++p;
  }
  if (!m.is_base()) {
    out << "  MODEL_" << m.inherit() << "::parse_params(cmd);\n";
  }
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_post_parse(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::post_parse()\n{\n";
  if (!m.is_base()) {
    out << "  MODEL_" << m.inherit() << "::post_parse();\n";
  }
  make_final_adjust(out, m.independent());
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_print_front(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::print_front(OMSTREAM& o)const\n{\n";
  {if (!m.key_list().is_empty()) {
    out << "  {";
    Key_List::const_iterator k = m.key_list().begin();
    for (;;) {
      out << "if (" << (**k).var() << " == " << (**k).value() << ") {\n"
	  << "    o << \"  " << to_lower((**k).name()) << "\";\n";
      ++k;
      if (k == m.key_list().end()){
	break;
      }
      out << "  }else ";
    }
    out << "  }else{\n";
    {if (!m.is_base()) {
      out << "    MODEL_" << m.inherit() << "::print_front(o);\n";
    }else{
      out << "    unreachable();\n";
    }}
    out << "  }}\n";
  }else{
    if (!m.is_base()) {
      out << "  MODEL_" << m.inherit() << "::print_front(o);\n";
    }
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_print_params(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::print_params(OMSTREAM& o)const\n{\n";
  
  if (m.level() != "") {
    out << "  o << \"level=" << m.level() << "\";\n";
  }
  if (!m.is_base()) {
    out << "  MODEL_" << m.inherit() << "::print_params(o);\n";
  }

  for (Parameter_List::const_iterator
	 p = m.independent().override().begin();
       p != m.independent().override().end(); ++p) {
    if (!((**p).user_name().empty())) {
      {if (!((**p).print_test().empty())) {
	out << "  if (" << (**p).print_test() << ")\n  ";
      }else if ((**p).default_val() == "NA") {
	out << "  if (" << (**p).code_name() << " != NA)\n  ";
      }}
      out << "  o << \"  " << to_lower((**p).user_name()) << "=\" << " 
	  << (**p).code_name();
      if (!((**p).offset().empty())) {
	out << "-(" << (**p).offset() << ")";
      }
      if (!((**p).scale().empty())) {
	out << "/(" << (**p).scale() << ")";
      }
      out << ";\n";
    }
  }

  for (Parameter_List::const_iterator
	 p = m.size_dependent().raw().begin();
       p != m.size_dependent().raw().end(); ++p) {
    if (!((**p).user_name().empty())) {
      out << "  " << (**p).code_name() << ".print(o, \"" 
	  << to_lower((**p).user_name()) << "\");\n";
    }
  }

  for (Parameter_List::const_iterator
	 p = m.independent().raw().begin();
       p != m.independent().raw().end(); ++p) {
    if (!((**p).user_name().empty())) {
      {if (!((**p).print_test().empty())) {
	out << "  if (" << (**p).print_test() << ")\n  ";
      }else if ((**p).default_val() == "NA") {
	out << "  if (" << (**p).code_name() << " != NA)\n  ";
      }}
      out << "  o << \"  " << to_lower((**p).user_name()) << "=\" << " 
	  << (**p).code_name();
      if (!((**p).offset().empty())) {
	out << "-(" << (**p).offset() << ")";
      }
      if (!((**p).scale().empty())) {
	out << "/(" << (**p).scale() << ")";
      }
      out << ";\n";
    }
  }

  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_print_calculated(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() 
      << "::print_calculated(OMSTREAM& o)const\n{\n";
  if (!m.is_base()) {
    out << "  MODEL_" << m.inherit() << "::print_calculated(o);\n";
  }
  Parameter_List::const_iterator p = m.independent().override().begin();
  for (;;) {
    if (p == m.independent().override().end()) {
      p = m.independent().raw().begin();
    }
    if (p == m.independent().raw().end()) {
      p = m.independent().calculated().begin();
    }
    if (p == m.independent().calculated().end()) {
      break;
    }
    if (!((**p).user_name().empty()) && !((**p).calc_print_test().empty())) {
      out << "  if (" << (**p).calc_print_test() << ")\n  "
	"  o << \"* " << to_lower((**p).user_name()) << "=\" << " 
	  << (**p).code_name();
      if (!((**p).offset().empty())) {
	out << "-(" << (**p).offset() << ")";
      }
      if (!((**p).scale().empty())) {
	out << "/(" << (**p).scale() << ")";
      }
      out << ";\n";
    }
    ++p;
  }

  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_tr_eval(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::tr_eval(COMPONENT*";
  {if (m.tr_eval().is_empty() && m.temperature().is_empty()) {
    out << ")const\n{\n";
  }else{
    out << " brh)const\n{\n"
      "  DEV_" << m.root() << "* d = prechecked_cast<DEV_"
	<< m.root() << "*>(brh);\n"
      "  assert(d);\n"
      "  const " << m.root() << "_COMMON* c = prechecked_cast<const " 
	<< m.root() << "_COMMON*>(d->common());\n"
      "  assert(c);\n"
      "  const SDP_" << m.name() << "* b = prechecked_cast<const SDP_" 
	<< m.name() << "*>(c->sdp);\n"
      "  assert(b);\n"
      "  const MODEL_" << m.name() << "* m = this;\n";
    if (!m.temperature().is_empty()) {
      out << "  TDP_" << m.name() << " t(d);\n";
    }
    out << m.tr_eval();
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
void make_cc_file(const File& in)
{
  std::string dump_name = in.name();
  dump_name.erase(dump_name.rfind(".model"));
  std::ofstream out((dump_name+".cc").c_str());
  if (!out) {
    untested();
    os_error(dump_name);
  }
  dump_name.erase(dump_name.find("../"),3);

  make_header(out, in, dump_name);

  for (Model_List::const_iterator
	 m = in.models().begin();  m != in.models().end();  ++m) {
    out << "int MODEL_" << (**m).name() << "::_count = 0;\n"
      "/*--------------------------------------"
      "------------------------------------*/\n";
    make_sdp_constructor(out, **m);
    make_tdp_constructor(out, **m);
    make_model_constructor(out, **m);
    make_parse_front(out, **m);
    make_parse_params(out, **m);
    make_post_parse(out, **m);
    make_print_front(out, **m);
    make_print_params(out, **m);
    make_print_calculated(out, **m);
    make_tr_eval(out, **m);
    out << "/*--------------------------------------"
      "------------------------------------*/\n";
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
