/*$Id: mg_in.cc,v 18.10 2000/08/20 05:31:33 al Exp $ -*- C++ -*-
 */
#include <fcntl.h>
#include <stdio.h>
#include "mg_.h"
/*--------------------------------------------------------------------------*/
static C_Comment   dummy_c_comment;
static Cxx_Comment dummy_cxx_comment;
/*--------------------------------------------------------------------------*/
void Key_List::parse(CS& file)
{
  int paren = file.skip1b("{");
  int here = file.cursor();
  for (;;){
    get(file, "/*$$", &dummy_c_comment);
    get(file, "//$$", &dummy_cxx_comment);
    paren -= file.skip1b("}");
    if (paren == 0){
      break;
    }
    Key* p = new Key(file);
    {if (!file.stuck(&here)){
      _kl.push_back(p);
    }else {
      delete p;
      file.warn(0, "bad key");
      break;
    }}
  }
}
/*--------------------------------------------------------------------------*/
void Parameter::parse(CS& file)
{
  file >> _type >> _code_name >> _comment;
  int here = file.cursor();
  for (;;){
    get(file, "Name",		&_user_name);
    get(file, "ALT_name",	&_alt_name);
    get(file, "Default",	&_default_val);
    get(file, "OFFset",		&_offset);
    set(file, "POSitive",	&_positive,	true);
    get(file, "PRInt_test",	&_print_test);
    get(file, "CALC_Print_test",&_calc_print_test);
    get(file, "SCAle",		&_scale);
    get(file, "CALCUlate",	&_calculate);
    get(file, "QUIET_MIN",	&_quiet_min);
    get(file, "QUIET_MAX",	&_quiet_max);
    get(file, "FINal_default",	&_final_default);
    get(file, "/*$$",		&dummy_c_comment);
    get(file, "//$$",		&dummy_cxx_comment);
    {if (file.skip1(";")){
      break;
    }else if (!file.more()){
      file.warn(0, "premature EOF (Parameter)");
      break;
    }else if (file.stuck(&here)){
      file.warn(0, "need ;");
      break;
    }}
  }
}
/*--------------------------------------------------------------------------*/
void Parameter_List::parse(CS& file)
{
  int paren = file.skip1b("{");
  int here = file.cursor();
  for (;;){
    get(file, "/*$$", &dummy_c_comment);
    get(file, "//$$", &dummy_cxx_comment);
    paren -= file.skip1b("}");
    if (paren == 0){
      break;
    }
    Parameter* p = new Parameter(file);
    {if (!file.stuck(&here)){
      _pl.push_back(p);
    }else {
      delete p;
      file.warn(0, "bad parameter");
      break;
    }}
  }
}
/*--------------------------------------------------------------------------*/
void Code_Block::parse(CS& file) 
{
  int paren = file.skipbl().skip1("{");
  int here = file.cursor();
  _begin = file.tail();
  for (;;){
    paren -= file.skip1b("])");
    if (paren == 0){
      file.warn(0, "unbalanced {}[]()");
      break;
    }
    _end = file.tail();
    paren -= file.skip1b("}");
    if (paren == 0){
      while (*(--_end) != '\n' && _end >= _begin){
      }
      ++_end;
      break;
    }
    if (file.stuck(&here)){
      file.warn(0, "syntax error");
      break;
    }
    paren += file.skip1b("{[(");
    file.skip1b(";");
    std::string foo;
    file >> foo;
  }
}
/*--------------------------------------------------------------------------*/
void Parameter_Block::parse(CS& file)
{ 
  int paren = file.skip1b("{");
  int here = file.cursor();
  for (;;){
    get(file, "OVErride",		&_override);
    get(file, "RAW_parameters",		&_raw);
    get(file, "CALculated_parameters",	&_calculated);
    get(file, "CODE_Front",		&_code_front);
    get(file, "CODe",			&_code);
    get(file, "/*$$",			&dummy_c_comment);
    get(file, "//$$",			&dummy_cxx_comment);
    paren -= file.skip1b("}");
    {if (paren == 0){
      break;
    }else if (!file.more()){
      file.warn(0, "premature EOF (Parameter_Block");
      break;
    }else if (file.stuck(&here)){
      file.warn(0, "bad Parameter_Code_Block");
      break;
    }}
  }
}
/*--------------------------------------------------------------------------*/
void Model::parse(CS& file)
{
  //_name = file.ctos("{");
  file >> _name;
  int paren = file.skip1b("{");
  int here = file.cursor();
  for (;;){
    get(file, "BASe",			&_is_base);
    get(file, "LEVel",			&_level);
    get(file, "ROOt",			&_root);
    get(file, "INHerit",		&_inherit);
    get(file, "KEYs",			&_key_list);
    get(file, "INDependent",		&_independent);
    get(file, "SIZe_dependent",		&_size_dependent);
    get(file, "TEMperature_dependent",	&_temperature);
    get(file, "TR_eval",		&_tr_eval);
    get(file, "/*$$",			&dummy_c_comment);
    get(file, "//$$",			&dummy_cxx_comment);
    paren -= file.skip1b("}");
    {if (paren == 0){
      break;
    }else if (!file.more()){
      file.warn(0, "premature EOF (Model)");
      break;
    }else if (file.stuck(&here)){
      file.warn(0, "bad Model");
      break;
    }}
  }
}
/*--------------------------------------------------------------------------*/
void Model_List::parse(CS& file) 
{
  int here = file.cursor();
  Model* m = new Model(file);
  {if (!file.stuck(&here)){
    _ml.push_back(m);
  }else{
    delete m;
    file.warn(0, "really bad model");
  }}
}
/*--------------------------------------------------------------------------*/
void C_Comment::parse(CS& file)
{
  int here = file.cursor();
  for (;;){
    file.skipto('*');
    {if (file.pmatch("*/$$")){
      break;  // done with comment
    }else if (file.stuck(&here)){
      file.warn(0, "unterminated C comment");
      break;
    }else{
      file.skip();
    }}
  }
}
/*--------------------------------------------------------------------------*/
void Cxx_Comment::parse(CS& file)
{
  int here = file.cursor();
  file.skipto('\n');
  if (file.stuck(&here)){
    file.warn(0, "unterminated C++ comment");
  }
}
/*--------------------------------------------------------------------------*/
void Head::parse(CS& file)
{
  int here = file.cursor();
  _begin = file.fullstring();
  for (;;){
    file.skipto('*');
    {if (file.pmatch("*/$$")){
      _end = file.tail();
      break;  // done with head
    }else if (file.stuck(&here)){
      file.warn(0, "unterminated head");
      break;
    }else{
      file.skip();
    }}
  }
}
/*--------------------------------------------------------------------------*/
File::File(const std::string& file_name)
  :_name(file_name),
   _file(0),
   _head(),
   _model_list()
{
  { // create a CS containing the entire file
    int f = open(_name.c_str(), O_RDONLY);
    if (f == EOF){
      untested();
      os_error(_name);
    }
    off_t size = lseek(f, off_t(0), SEEK_END);
    lseek(f, off_t(0), SEEK_SET);
    char* buf = new char[size+2];
    read(f, buf, size);
    close(f);
    _file = new CS(buf);
    delete [] buf;
  }
  get(*_file, "/*$$",		&_head);
  int here = _file->cursor();
  for (;;){
    get(*_file, "H_Headers",	&_h_headers);
    get(*_file, "CC_headers",	&_cc_headers);
    get(*_file, "MODel",	&_model_list);
    get(*_file, "/*$$",		&dummy_c_comment);
    get(*_file, "//$$",		&dummy_cxx_comment);
    {if (!_file->more()){
      break;
    }else if (_file->stuck(&here)){
      _file->warn(0, "syntax error, need head or model");
      break;
    }}
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
