/*$Id: mg_error.cc,v 17.23 2000/05/26 07:54:22 al Exp $ -*- C++ -*-
 * Error handler.
 */
#include "ap.h"
/*--------------------------------------------------------------------------*/
//	CS &	CS::check(int i, const std::string& s);
//	CS &	CS::warn(int i, int c, const std::string& s);
/*--------------------------------------------------------------------------*/
/* syntax_check: handle syntax errors
 * called on parsing an input string when nothing else matches.
 * if the rest of the line is nothing, just return
 * if comment, increment *cnt, so what is left is a valid comment string
 * otherwise, it is an error (the arrow pointing at the offending word)
 */
CS & CS::check(int badness, const std::string& message)
{
  skipbl();
  switch (peek()){
    case '\'':	_ok = true;  skip();	   break;
    case '\0':	_ok = true;		   break;
    default:	_ok = false; warn(badness, message); break;
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
static void tab(int n)
{
  for (int i=0; i<n; ++i){
    std::cerr << ' ';
  }
}
/*--------------------------------------------------------------------------*/
/* syntax_msg: print syntax error message
 * echo a portion of the input with an arrow pointing to the current place
 */
CS & CS::warn(int badness, int spot, const std::string& message)
{
  if (badness >= 0){
    {if (spot < 10){
      std::cerr.form("%.20s\n", _cmd);
      tab(spot);
    }else{
      std::cerr.form("..%.20s\n............", &_cmd[spot-10]);
    }}
    std::cerr << "^ ? " << message << '\n';
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
