/*$Id: ap_skip.cc,v 18.9 2000/08/16 08:11:43 al Exp $ -*- C++ -*-
 * collection of functions to skip input
 * all except skip1 skip leading whitespace, skip whatever is being skipped,
 * then skip trailing whitespace.
 */
#include <assert.h>
#include "ap.h"
/*--------------------------------------------------------------------------*/
//	CS&	CS::skipbl();
//	CS&	CS::skip1b(const std::string&);
//	CS&	CS::skip1(const std::string&);
//	CS&	CS::skiparg();
//	CS&	CS::skipto(const std::string& t)
//	CS&	CS::skipto(char c)
/*--------------------------------------------------------------------------*/
/* skipbl: skip whitespace.  (any non-graphic character is ws)
 * =,(,) are also ws
 * update string pointer
 * pointer points to first non-space
 * does NOT update _ok flag
 */
CS& CS::skipbl()
{
  while (peek() && (!isgraph(peek()))) {
    skip();
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/* skip1b: skip 1 matching character and surrounding blanks 
 * _ok = did it
 */
CS& CS::skip1b(const std::string& t)
{
  skipbl();
  skip1(t);
  skipbl();
  return *this;
}
/*--------------------------------------------------------------------------*/
/* skip1: skip 1 character matching any in t
 * _ok = did it
 */
CS& CS::skip1(const std::string& t)
{
  if (match1(t)) {
    skip();
    assert(_ok);
  }else{
    _ok = false;
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/* skiparg: skip an argument (maybe just a comma)
 * _ok = skipped something
 */
CS& CS::skiparg()
{
  int here = cursor();
  if (!skipcom()) {
    if (peek()) {
      skip();
    }
    while (is_alpha() || is_pfloat() || is_argsym()) {
      skip();
    }
    skipcom();
  }
  _ok = cursor() > here;
  return *this;
}
/*--------------------------------------------------------------------------*/
/* skipto: skip to a character (one of ...)
 * _ok = skipped something
 */
CS& CS::skipto(const std::string& t)
{
  int here = cursor();
  while (ns_more() && !match1(t)) {
    skip();
  }
  _ok = ns_more();
  if (!_ok) {
    reset(here);
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/* skipto: skip to a character (explicit)
 * _ok = skipped something
 */
CS& CS::skipto(char c)
{
  int here = cursor();
  while (ns_more() && !match(c)) {
    skip();
  }
  _ok = ns_more();
  if (!_ok) {
    reset(here);
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
