/*
 * create_user.c - Para criar o ficheiro de passwords
 * 
 * 
 * (c) 1998 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 
 */


#define PROGRAM_NAME "IO256pwd"
#define PROGRAM_VERSION "0.01"
#define AUTHOR_NAME "Nuno Sucena <slug@student.dee.uc.pt>"

#define OK 1
#define ERRO !OK
#define MAX_LINE_LENGTH 1024
#define V_PASSWORD_FILE "password.cfg"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <time.h>

char *V_password_file;

void mostra_versao (void)
{
   fprintf (stderr, "%s %s por %s\n%s %s gcc %s\n\n",
	    PROGRAM_NAME, PROGRAM_VERSION , AUTHOR_NAME,
	    __DATE__ , __TIME__ , __VERSION__ );
}

void mostra_ajuda(void)
{
   printf ("\t-f\tFicheiro de palavras-chave\n\
\t-v\tMostra versao do programa\n\
\t-h\tEsta ajuda\n\n" );
}
 
int parse_options ( int argc , char *argv[] )
{
   char c;
   V_password_file = NULL;
   opterr = 0;
   mostra_versao();
   while (( c = getopt ( argc , argv , "vVhHf:" ))!=-1 )
     switch (c)
     {
      case '?': /* Opcao invalida */
	fprintf (stderr,"'-%c' - Opcao invalida ou especificada de modo incorrecto\a\n\n" ,
		 optopt);
	mostra_ajuda();
	return ( ERRO );
      case 'f': /* Ficheiro de passwords */
	V_password_file = strdup ( optarg );
	break;
      case 'v': /* Mostra versao */
      case 'V':
	return ( ERRO );
      case 'h': /* Mostra ajuda */
      case 'H':
	mostra_ajuda();
	return ( ERRO );
      default:
	break;
     }
   if ( V_password_file == NULL ) V_password_file = strdup ( V_PASSWORD_FILE );
   return ( OK );
}

int read_from_user ( char *nome , char **password )
{
   char *temp;
   time_t tempo;
   char salt[3];
   printf ( "Enter name:" );
   fflush ( NULL );
   scanf ( "%[^\n]s" , nome );
   temp = getpass ( "Enter password:" );
   tempo = time ( NULL );
   strftime ( salt , 3 , "%S" , localtime (&tempo));
   *password = crypt ( temp , salt );
   return ( OK );
}

int write_to_file ( char *ficheiro , char *nome , char *password )
{
   FILE *file;
   if (( nome == NULL ) || ( password == NULL ))
     return ( ERRO );
   if ( (file = fopen ( ficheiro , "a" ))==NULL )
     {
	perror ( ficheiro );
	return ( ERRO );
     }
   if ( fprintf ( file , "%s:%s\n" , nome , password ) < 0 )
     {
	perror (ficheiro);
	fclose (file);
	return (ERRO);
     }
   fclose ( file );
   return ( OK );
}

int main ( int argc , char *argv[] )
{
   char nome[MAX_LINE_LENGTH] , *password;
   if ( parse_options ( argc , argv ) == ERRO )
     return ( EXIT_FAILURE );
   if ( read_from_user ( nome , &password ) == ERRO )
     return ( EXIT_FAILURE );
/*   printf ( "Nome: [%s]\tPassword: [%s]\n\n" , nome , password );*/
   if ( write_to_file ( V_password_file , nome , password ) == ERRO )
     return ( EXIT_FAILURE );
   return ( EXIT_SUCCESS );
}
