/*
 * cliente_util.c - Funes teis para o cliente do IO256
 * 
 * (c) 1998 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "config.h"
#include "cliente_util.h"
#include "cliente_sock.h"

void mostra_versao (void)
{
   fprintf (stderr, "%s %s por %s\n%s %s gcc %s\n\n",
	    PROGRAM_NAME, PROGRAM_VERSION , AUTHOR_NAME,
	    __DATE__ , __TIME__ , __VERSION__ );
}

void mostra_ajuda(void)
{
   printf ("\t-e\tEndereo para onde ligar\n\
\t-s\tServio de ligao\n\
\t-v\tMostra verso do programa\n\
\t-h\tEsta ajuda\n\n" );
}

int parse_client_options ( int argc , char *argv[] )
{
   char c;
   V_servico = NULL;
   V_endereco = NULL;
   opterr = 0;
   mostra_versao();
   while (( c = getopt ( argc , argv , "vVhHe:s:" ))!=-1 )
     switch (c)
     {
      case '?' : /* Opcao desconhecida ou invalida */
	fprintf (stderr,"'-%c' - Opo invlida ou especificada de modo incorrecto\a\n\n",
		 optopt);
	mostra_ajuda();
	return (ERRO);

	break;
      case 'e': /* Endereo de ligao */
	V_endereco = strdup ( optarg );
	break;
      case 's': /* Servico de ligacao */
	V_servico = strdup ( optarg );
	break;
      case 'v':
      case 'V':
	return ( ERRO );
	break;
      case 'h':
      case 'H':
	mostra_ajuda();
	return ( ERRO );
	break;
      default:
	break;
     }
   if ( V_servico == NULL ) V_servico = strdup ( V_SERVICO );
   if ( V_endereco == NULL ) V_endereco = strdup ( V_ENDERECO );
   return ( OK );
}

int parse_client_commands ( int soquete )
{
   char *command_list[] = { "send" , "sleep" , "quit" , "exit" , "help" , "version" , NULL
   };
   char buffer[MAX_BUFFER];
   char *command , *option;
   int n , comando=0 , sleep_time;
/*   printf ("cliente>" );
   fflush ( stdout );*/
   if ( scanf ( " %[^\n]s" , buffer ) == 1 )
     {
	if ( (command = strtok ( buffer , COMMAND_SEPARATOR ))==NULL)
	  return ( ERRO );
	option = strtok ( NULL , "" );
	for ( n=0; command_list[n]!=NULL; n++)
	  if (strcmp ( command , command_list[n] )==0)
	  {
	     comando=n+1;
	     break;
	  }
	/* printf ("Comando: [%s]\tOpcao: [%s]\n", command , option != NULL ? option:"-");*/
	switch (comando)
	  {
	   case 1: /* send */
	     if ( option != NULL )
	       {
/*		  printf ("Sending...\n");*/
		  envia_mensagem ( soquete , option );
		  envia_mensagem ( soquete , "\n" );
/*		  sleep (1);*/
	       }
	     else printf ("client: Need more!\n");
	     break;
	   case 2: /* sleep */
	     if ( option != NULL )
	       {
		  if ( (sleep_time = strtol ( option , NULL , 0 ))!=0)
		    {
		       printf ("client : Sleeping for %d seconds...\n", sleep_time);
		       sleep ( sleep_time );
		    }
		  else printf ("client: Error!\a\n");
	       }
	     else printf ("client : Need more!\n");
	     break;
	   case 3: /* quit */
	   case 4: /* exit */
	     return (ERRO);
	   case 5: /* help */
	     for (n=0; command_list[n]!=NULL;n++)
	       printf ( "client: %s\n" , command_list[n] );
	     break;
	   case 6: /* version */
	     mostra_versao();
	     break;
	   default:
	     printf ("client: Unknown command\n");
	     break;
	  }
     }
   return ( OK );
}
