/*
 * cliente.c - Cliente para ligacao ao servidor IO256
 * 
 * 
 * (c) 1998 Nuno Sucena Almeida <slug@student.dee.uc.pt
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <netdb.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "config.h"
#include "cliente_sock.h"
#include "cliente_util.h"

int main ( int argc , char *argv[] )
{
   int soquete;
   char *nome=NULL , *endereco=NULL;
   struct hostent *hostname;
   fd_set read_fd_set , active_fd_set;
   char buffer[MAX_BUFFER];
   int comprimento;
   if ( parse_client_options ( argc , argv ) == ERRO )
     return ( EXIT_FAILURE );
   if ( ( hostname = gethostbyname ( V_endereco ))==NULL)
     {
	herror (V_endereco);
	return ( EXIT_FAILURE );
     }
   if ( cria_socket ( &soquete , "TCP" , V_servico ,
		     inet_ntoa(*((struct in_addr *)hostname->h_addr)) ,
		     CONNECT_TYPE ) == ERRO )
     return (EXIT_FAILURE);
   nome = nome_maquina ( soquete );
   endereco = endereco_maquina ( soquete );
   printf ("Connected to %s (%s)\n" , nome , endereco );
   FD_ZERO ( &active_fd_set );
   FD_SET ( STDIN_FILENO , &active_fd_set );
   FD_SET ( soquete , &active_fd_set );
   while (1)
     {
	read_fd_set = active_fd_set ;
	if ( select ( FD_SETSIZE , &read_fd_set , NULL , NULL , NULL ) < 0 )
	  {
	     perror ( "select" );
	     return ( EXIT_FAILURE );
	  }
	if ( FD_ISSET ( STDIN_FILENO , &read_fd_set ))
	  {
	     if ( parse_client_commands ( soquete ) != OK )
	       {
		  printf ("Connection closed by client.\n");
		  break;
	       }
	  }
	if ( FD_ISSET ( soquete , &read_fd_set ))
	  {
	     memset ( buffer , 0 , sizeof ( buffer ));
	     comprimento = recv ( soquete , buffer , MAX_BUFFER , 0 );
	     if ( comprimento > 0 )
	       {
		  printf ( buffer );
		  fflush ( stdout );
	       }
	     else
	       {
		  printf ("Connection closed by server.\n");
		  break;
	       }
	  }
     }
   close ( soquete );
   free(nome); free (endereco);
   return ( EXIT_SUCCESS);
}
