#include "header.h"

#define usagemsg { fprintf(stderr, "Usage: %s high|low addr\n", argv[0]); exit(2); }

int
main(int argc, char *argv[])
{

unsigned char addr, line;

if ( argc != 3 ) usagemsg;

addr = strtoul(argv[2],NULL,0);

if ( strncmp(argv[1], "h",1 ) == 0 ) {
	line = HI;
	printf("Setting high address to %#02x\n",addr);
} else if ( strncmp(argv[1], "l",1 ) == 0 ) {
	line = LO;
	printf("Setting low address to %#02x\n",addr);
} else {
	usagemsg;
}

if ( getperm() != 0 ) exit(1);
reset();

setadd(line, addr);

exit(0);

}

