/* $Id: header.h,v 1.9 2001/03/06 08:57:23 abhijit Exp $ */
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef __GLIBC__
#include <sys/io.h>
#else
#include <asm/io.h>
#endif

/* maximum capacity of EEPROMs in bytes */
#define MAXEEPROMSIZE 32768

/* the pc parallel port i/o base addresses */
#define LP0 0x3bc
#define LP1 0x378
#define LP2 0x278

/* dummy i/o base address for io delay */
#define DUMMYPORT 0x80

/* for addressing 74HCT138  */
#define DCLKLINE 0x0                /* latch data via '574 */
#define WELINE 0x1                  /* Memory write */
#define OELINE 0x2                  /* Memory read */
#define LOWLINE 0x3                 /* 1st '259 */
#define LO 0x3
#define HILINE 0x4                  /* 2nd '259 */
#define HI 0x4
#define UNUSEDLINE 0x6              /* Output 6 of '138 not connected */

#define OUT outb
#define IN inb
#define DELAYMULT 2
#define IODELAY {delay(DELAYMULT);}
#define WR_DELAY {usleep(2000);}

/* external variables in extern.h */
/*
#define DEFAULT_PORTBASE 0x3bc
#define DEFAULT_INPORT 0x3bd
#define DEFAULT_CNTRLPORT 0x3be

unsigned long portbase = DEFAULT_PORTBASE;
unsigned long inport = DEFAULT_INPORT;
unsigned long cntrlport = DEFAULT_CNTRLPORT;
unsigned long abselect = 0;

unsigned char INBUF[32768];
*/

/* functions */
int getperm(void);
void delay(unsigned long n);
void controlsetlow(void);
void controlsethigh(void);
void clkonce(void);
void set138address(unsigned char a);
void reset(void);
void setbit(unsigned char line, unsigned char pos, unsigned char t);
void setadd(unsigned char line, unsigned char c);
void disable574(void);
void enable574(void);
void enableram(void);
void clk574data(void);
void wrmem(void);
unsigned char convnibble(unsigned char c);
unsigned char rd574(void);
unsigned char rdmem(void);
void comm574test(void);
void antistick(void);
void readrom(unsigned char ot, unsigned long off, unsigned long sz);
void writerom(unsigned char ot, unsigned long off, unsigned long sz);

