/* $Id: functions.c,v 1.10 2001/03/06 08:57:23 abhijit Exp $ */
#include "header.h"
#include "externs.h"

extern unsigned long portbase, inport, cntrlport, abselect;
extern unsigned char INBUF[];

int getperm(void)
{
if (ioperm(DUMMYPORT,1,1) <0) {      /* delay port 0x80 */
	perror("ioperm()");
	fprintf(stderr, "This program must be run as root.\n");
	return 1;
}
/* set up permission for base+0, base+1, base+2 */
if (ioperm(portbase, 3, 1) < 0) {
	perror("ioperm()");
	fprintf(stderr, "This program must be run as root.\n");
	return 1;
}
abselect = 0;
return 0;
}

void delay(unsigned long n)
{
unsigned long i;
for (i = 0; i < n; i++) {
	OUT(0x0,DUMMYPORT);
	OUT(0x0,DUMMYPORT);
}
}


void controlsetlow(void)
{
OUT(0x0,cntrlport);
}


void controlsethigh(void)
{				/* logic 1 on all control lines, */
OUT(0x4,cntrlport);		/* interrupt disabled */
}


void clkonce(void)
{
/* Send out low-high on bit 2 (Init) of port base+2 (pin 16 of DB25).
All other control lines at logic 1. Interrupt disabled. */
controlsetlow();
IODELAY;
controlsethigh();
}


void set138address(unsigned char a)
{
/* Should not be used to control the 259s.  Use setbit for that */
a = (a & 0x7);
if ((a == HILINE) || (a == LOWLINE))
	fprintf(stderr, "Warning: Unknown data on 259\n");
a = ((a << 4) + 0xf) & 0x7f;
if (abselect & 0x1)
	a = (a | 0x80) ;
OUT(a,portbase);
OUT(a,portbase);
IODELAY;
}

void setbit(unsigned char line, unsigned char pos, unsigned char t)
{
/* This is for setting or clearing a single bit in one of the two
'259s. line must be "LO" or "HI", otherwise this function will do
nothing. pos is bit position (0-7), and t is bit-value (0/1).
Calling this function will set bit pos to t. */
unsigned char s;
if ( line != LO && line != HI )
	return;
pos = pos & 0x7;
t = t & 1;
s = ((line << 4) + (t << 3) + pos) & 0x7f;
if (abselect & 0x1)
	s = (s | 0x80);
OUT(s,portbase);
OUT(s,portbase);
IODELAY;
clkonce();
}


void setadd(unsigned char line, unsigned char c)
{
/* Set up low (A0-A7) or high (A8-A14) address lines of the EEPROM */
unsigned char bit,maxbits;
int i;
maxbits = 8;
if ( line != LO && line != HI )
	return;
if ( line == HI )	/* set only the low 7 bits of the upper '259 */
	maxbits = 7;
for (i=0; i<maxbits; i++) {             /* i is the bit-position */
	bit = (1 & c);                  /* get LSb */
	setbit(line,i,bit);
	IODELAY;
	c = c >> 1;                     /* next bit */
}
}


void disable574(void)
{
setbit(HI,7,1);
}


void enable574(void)
{
setbit(HI,7,0);
}


void reset(void)
{
setbit(HI,6,0);
IODELAY;
disable574();
controlsethigh();
IODELAY;
set138address(UNUSEDLINE);   /* '138 address set to an unused line */
IODELAY;
}


void enableram(void)
{
/* Note: This brings control low in a stuck fashion, the caller
         should explicitly do a controlsethigh() following a
         call of enableram(). */
/* Will not work unless disable 574 -OE before calling */
disable574();
IODELAY;
set138address(OELINE);
IODELAY;
controlsetlow();
IODELAY;
}


void clk574data(void)
{
set138address(DCLKLINE);
IODELAY;
clkonce();
}


void wrmem(void)
{
set138address(WELINE);
IODELAY;
clkonce();
IODELAY;
WR_DELAY;
}


unsigned char convnibble(unsigned char c)
{
unsigned char b;
b = (((c >> 4) & 0x8) ^ 0x8) + (0x7 & (c >> 3));
return b;
}


unsigned char rd574(void) {
unsigned char got,lnib,hnib,b;
/* lower nibble */
abselect = 0;
enable574();
IODELAY;
IODELAY;
got=IN(inport);
got=IN(inport);
lnib = convnibble(got);
/* upper nibble */
abselect = 1;
enable574();
IODELAY;
IODELAY;
got=IN(inport);
got=IN(inport);
hnib = convnibble(got);
b = (hnib << 4) + lnib;
return b;
}


unsigned char rdmem(void)
{
unsigned char got,lnib,hnib,b;
/* lower nibble */
abselect = 0;
enableram();
IODELAY;
got=IN(inport);
got=IN(inport);
IODELAY;
got=IN(inport);
lnib = convnibble(got);
controlsethigh();
IODELAY;
/* upper nibble */
abselect = 1;
enableram();
IODELAY;
got=IN(inport);
got=IN(inport);
IODELAY;
got=IN(inport);
hnib = convnibble(got);
controlsethigh();
IODELAY;
b = (hnib << 4) + lnib;
return b;
}

void comm574test(void)
{
unsigned int i;
unsigned char j,c;
fprintf(stderr, "Testing I/O between the parallel port and 'HCT574:\n");
for (i=0;i<256;i++) {
	j = i;
	setadd(LO,j);
	IODELAY;
	clk574data();
	IODELAY;
	c = rd574();
	if (c != j) {
		fprintf(stderr, "\nFatal error: I/O via 574 failed.\n");
		reset();
		exit(3);
	}
	fprintf(stderr, "!");
	if (((i+1)%64) == 0)
		fprintf(stderr, "\n");
}
fprintf(stderr, "Test OK.\n");
reset();
}

void readrom(unsigned char ot, unsigned long off, unsigned long sz)
{
unsigned int i;
unsigned char c, low, high;
fprintf(stderr, "Reading ... ");
for (i=off; i < off+sz; i++) {
	antistick();
	low = ( i & 0xff );
	high = ( ( i >> 8 ) & 0x7f );
	setadd(LO,low);
	IODELAY;
	setadd(HI,high);
	IODELAY;
	IODELAY;
	c = rdmem();
	IODELAY;
	if (ot == 'b')
		putchar(c);
	else {			/* text output */
		if (i == off)
			fprintf(stderr,"\n");
		printf("Address 0x%04x has data byte 0x%02x\n",i,c);
		/*
		if ( ((i-off)%16) == 0 )
			printf("\n0x%04x  ",i);
		printf(" %02x",c);
		if (i+1 == off+sz)
			printf("\n");
		*/
	}
}
IODELAY;
reset();
fprintf(stderr, "done.\n");
}


void writerom(unsigned char ot, unsigned long off, unsigned long sz)
{
int i, nr;
unsigned char c, g, low, high;
for (i=off; i < off+sz; i++) {
	if ((nr = getchar()) == EOF) {
		fprintf(stderr, "Fatal error: read from stdin\n");
		reset();
		exit(3);
	}
	c = nr;
	INBUF[i] = c;
}
fprintf(stderr, "Writing eeprom, 64 bytes per hash mark:\n");
for (i=off; i < off+sz; i++) {
	low = ( i & 0xff );
	high = ( ( i >> 8 ) & 0x7f );
	c = INBUF[i];
	/* First load the data byte onto data bus */
	setadd(LO,c);		/* put data byte into 574 */
	IODELAY;
	clk574data();		/* 574 now holds data byte in its memory */
	IODELAY;
	enable574();		/* put data byte onto data bus */
	IODELAY;
	/* double check data bus */
	g = rd574();
	if (g != c) {
		fprintf(stderr, "\nFatal error before write at address 0x%04x:\n",i);
		fprintf(stderr, "Put 0x%02x on data bus, but got back 0x%02x\n",c,g);
		reset();
		exit(3);
	}
	/* next setup address bus */
	setadd(LO,low);
	IODELAY;
	setadd(HI,high);
	IODELAY;
	IODELAY;
	/* clock /WR line */
	wrmem();
	WR_DELAY;
	IODELAY;
	if ((i-off)%64 == 63)
		fprintf(stderr,"#");
	if ((i-off)%4096 == 4095)
		fprintf(stderr,"\n");
}
if ((i-off)%4096 != 0 && (i-off) > 63)
	fprintf(stderr,"\n");
fprintf(stderr,"Writing done.  Verifying ...\n");
reset();
WR_DELAY;
/* verify written data */
for (i=off; i < off+sz; i++) {
	antistick();
	low = ( i & 0xff );
	high = ( ( i >> 8 ) & 0x7f );
	c = INBUF[i];
	setadd(LO,low);
	IODELAY;
	setadd(HI,high);
	IODELAY;
	IODELAY;
	g = rdmem();
	if (g != c) {
		fprintf(stderr, "\nFatal error: Wrote 0x%02x, got 0x%02x at address 0x%04x\n",c,g,i);
		reset();
		exit(3);
	}
	if (ot == 't') {	/* print value */
		if ( ((i-off)%16) == 0 )
			printf("0x%04x  ",i);
		printf(" %02x",c);
		if ( ((i-off)%16) == 15 ) printf("\n");
		/* printf("Adderss 0x%04x -> 0x%02x\n",i,c); */
	}

}
if ( ((i-off)%16) != 0 && ot == 't') printf("\n");
IODELAY;
disable574();
IODELAY;
reset();
printf("Wrote and verified 0x%04lx bytes\n",sz);
while ((nr = getchar()) != EOF);
}


void antistick(void)
{
unsigned int i;
unsigned char j,c;
j = 0xff;
for (i=0;i<4;i++) {
	j = j ^ 0xff;
	IODELAY;
	setadd(LO,j);
	IODELAY;
	clk574data();
	IODELAY;
	c = rd574();
	if (c != j) {
		fprintf(stderr, "\nFatal error: antistick(): I/O via 574 failed, bit stuck?\n");
		reset();
		exit(3);
	}
}
}
