/* $Id: eep.c,v 1.6 2001/03/07 02:22:11 abhijit Exp $ */
#include "header.h"

extern unsigned long portbase, inport, cntrlport, abselect;
extern unsigned char INBUF[];

int
usage(char *s)
{
fprintf(stderr, "Usage:\n\n");
fprintf(stderr, "      %s  -0|-1|-2  -r|-w  -b|-t  offset  size\n\n", s);
fprintf(stderr, "where:\n\n\
    -0|-1|-2  -0 chooses port lp0, -1 port lp1, and -2 port lp2,\n\
    -r|-w     -r reads the eeprom to stdout, and -w burns it from stdin,\n\
    -b|-t     -b is normal (binary) mode, and -t is debugging (ascii hex),\n\
    offset    is the start address within the eeprom, 0..32767, and,\n\
    size      is the number of bytes to read/write, 0..32768.\n\n");
exit(2);
}

int
main(int argc, char *argv[])
{

unsigned long off, sz;
int i;
char *s;

s = argv[0];
if ( argc != 6 ) usage(s);
for (i=1;i<=3;i++) {
	if (*(argv[i]) != '-')
		 usage(s);
	(argv[i])++;
}
if (*(argv[3]) != 'b' && *(argv[3]) != 't') usage(s);
off = strtoul(argv[4],NULL,0);
if ( off < 0 || off > MAXEEPROMSIZE )
	usage(s);
sz = strtoul(argv[5],NULL,0);
if ( sz < 0 || (off+sz) > MAXEEPROMSIZE )
	usage(s);
switch (*(argv[1])) {
	case '0':
		portbase = LP0;
		break;
	case '1':
		portbase = LP1;
		break;
	case '2':
		portbase = LP2;
		break;
	default:
		usage(s);
		break;
}
inport = portbase + 1;
cntrlport = portbase + 2;
if ( getperm() != 0 )
	exit(1);
reset();
IODELAY;
comm574test();
if (*(argv[2]) == 'r')
	readrom(*(argv[3]),off,sz);
else if (*(argv[2]) == 'w')
	writerom(*(argv[3]),off,sz);
else
	usage(s);
reset();
exit(0);

}

