#ifndef MISC_H
#define MISC_H 1

/* $Id: misc.h,v 1.3 1997/10/28 10:11:20 ukrebeld Exp ukrebeld $ */

#define E_NOERROR 0		/* ok, no error */
#define E_IO 1			/* I/O error */
#define E_EOF 2			/* end of file */
#define E_FORMAT 3		/* bad format */
#define E_NOMEM 4		/* out of memory */
#define E_INVAL 5		/* invalid argument */
#define MAXERROR 5

typedef struct option {
	int short_opt;
	char *long_opt;
} OPTION;

#define optnum(array) (sizeof(array) / sizeof(array[0]))

extern void setoption(int argc, char *argv[], OPTION *, unsigned);
extern void errmsg(char *form,...);
extern char *getbase(char *, char *suffix);
extern char *getprogram(void);
extern OPTION *getoption(void);
extern char *getparam(void);
extern int getlparam(long *);
extern int getdparam(double *);
extern int opteol(void);

#ifdef NDEBUG
#define DEBUG(args) ((void)0)
#else
extern void debugmsg(long priority, char*, ...);
#define DEBUG(args) debugmsg args
#endif

extern long debuglevel;

#define DEBUG_ON (-1)
#define DEBUG_OFF 0

#endif				/* MISC_H */
