/* $Id: misc.c,v 1.3 1997/10/28 10:11:20 ukrebeld Exp ukrebeld $ */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include "misc.h"

#define OPTSTRICT 1 /* 0, 2 */

char *getbase(char *path, char *suffix)
{
	char *p = path, *q;

	assert(path != 0);
	while (*p != '\0') {
		if (*p == '/') {
			q = p;
			while (*++p == '/')
				(void) 0;
			if (*p != '\0')
				path = p;
			else {
				p = q;
				*p = '\0';
			}
		} else
			++p;
	}
	if ((q = suffix) != 0) {
		/* suffix deletion */
		while (*q != '\0')
			++q;
		while (q != suffix && p != path && *--q == *--p)
			(void) 0;
		if (q == suffix && p != path && *q == *p)
			*p = '\0';
	}
	return path;
}

static char **argv;
static int argc;
static char **curarg;
static char *curchar;
static OPTION *opt;
static int optc;

char *getprogram(void)
{
	if (argv == 0)
		return 0;
	return getbase(*argv, 0);
}

void errmsg(char *form,...)
{
	char *p;
	va_list ap;

	assert(form != 0);
	p = getprogram();
	if (p != 0 && *p != '\0')
		fprintf(stderr, "%s: ", p);
	va_start(ap, form);
	vfprintf(stderr, form, ap);
	va_end(ap);
	fprintf(stderr, ".\n");
}

void setoption(int l_argc, char *l_argv[],
		OPTION * l_opt, unsigned l_optc)
{
	assert(l_argc > 0 && l_argv != 0
		&& l_argv[0] != 0 && l_argv[l_argc] == 0);
	assert((l_opt != 0 && l_optc != 0)
		|| (l_opt == 0 && l_optc == 0));

	argc = l_argc;
	argv = l_argv;
	opt = l_opt;
	optc = l_optc;
	curarg = l_argv + 1;
	curchar = "";
}

static OPTION *longopt(char *s)
{
	OPTION *p, *q;

	assert(s != 0);
	p = opt;
	q = p + optc;
	while (p < q) {
		if (p->long_opt != 0 && strcmp(p->long_opt, s) == 0)
			return p;
		++p;
	}
	return 0;
}

static OPTION *shortopt(int c)
{
	OPTION *p, *q;

	assert (c != 0);
	p = opt;
	q = p + optc;
	while (p < q) {
		if (p->short_opt == c)
			return p;
		++p;
	}
	return 0;
}

static void *getargument(int needparam)
{
	char *p;
	void *op = 0;

	if (argv == 0)
		return 0;
	if (*curchar != '\0') {
		/* group of short options with
		   optional parameter added */
		if ((op = shortopt(*curchar)) != 0) {
			if (needparam != 0)
				op = 0;
			else
				++curchar;
		}
#if OPTSTRICT == 1
		else if (isalpha(*curchar))
			/* short options are alpha
			   characters, parameter may not
			   start with alpha() character */
			(void)0;
#endif
#if OPTSTRICT == 0 || OPTSTRICT == 1
		else
			if (needparam != 0) {
				op = curchar;
				curchar = "";
			}
#endif
	}
	else if ((p = *curarg) != 0) {
		if (*p == '-' && *++p != '\0') {
			if ((op = longopt(p)) != 0) {
				if (needparam != 0)
					op = 0;
				else
					++curarg;
			} else if ((op = shortopt(*p)) != 0) {
				if (needparam != 0)
					op = 0;
				else {
					++curarg;
					curchar = p + 1;
				}
			}
#if OPTSTRICT == 1
			else if (isalpha(*p))
				/* short options are alpha
				   characters, parameter may not
				   start with alpha() character */
				(void)0;
#endif
#if OPTSTRICT == 0 || OPTSTRICT == 1
			else
				if (needparam != 0)
					op = *curarg++;
#endif
		} else
			if (needparam != 0)
				op = *curarg++;
	}
	return op;
}

OPTION *getoption(void)
{
	return getargument(0);
}

char *getparam(void)
{
	return getargument(-1);
}

int getlparam(long *value)
{
	char *p, *q;

	if ((p = getparam()) == NULL)
		return -1;
	*value = strtol(p, &q, 0);
	if (p == q || *q != '\0')
		return -1;
	return 0;
}

int getdparam(double *value)
{
	char *p, *q;

	if ((p = getparam()) == NULL)
		return -1;
	*value = strtod(p, &q);
	if (p == q || *q != '\0')
		return -1;
	return 0;
}

int opteol(void)
{
	if (argv == 0 || (*curchar == '\0' && *curarg == 0))
		return -1;
	return 0;
}

long debuglevel = 0;

#ifndef NDEBUG
void debugmsg(long priority, char *form,...)
{
	va_list ap;

	if (!(debuglevel & priority))
		return;
	va_start(ap, form);
	vfprintf(stderr, form, ap);
	va_end(ap);
	fprintf(stderr, "\n");
}
#endif
