#include <stdio.h>

#ifndef strcmp
#include <string.h>
#endif

#ifndef atoi
#include <stdlib.h>
#endif

#ifndef exit
#include <unistd.h>
#endif

#include <X11/Xlib.h>

main(int argc, char *argv[])
{
    Display *dpy;
    Cursor XRootCur;
    Window XRootWin;
    char *display_name = NULL;
    int curs = 0;
    Font CurFont;
    XColor fg, bg;
    Colormap colmap;

    if (argc > 1) {
	if (!strcmp(argv[1], "--help")) {
	    fprintf(stderr, "Usage: %s [cursor] [0|1] [font] \n", argv[0]);
	    exit(1);
	}
	curs = atoi(argv[1]);
    }
    if (!(dpy = XOpenDisplay(display_name))) {
	fprintf(stderr, "can't open display %s (this is an X windows program)\n", XDisplayName(display_name));
	exit(1);
    }
    CurFont = XLoadFont(dpy, (argc > 3 ? argv[3] : "cursor"));

    colmap = DefaultColormap(dpy, DefaultScreen(dpy));
    fg.pixel = BlackPixel(dpy, DefaultScreen(dpy));
    XQueryColor(dpy, colmap, &fg);
    bg.pixel = WhitePixel(dpy, DefaultScreen(dpy));
    XQueryColor(dpy, colmap, &bg);

    if (argc > 2 && atoi(argv[2]))
	XRootCur = XCreateGlyphCursor(dpy, CurFont, CurFont, curs, curs + 1, &bg, &fg);
    else
	XRootCur = XCreateGlyphCursor(dpy, CurFont, CurFont, curs, curs + 1, &fg, &bg);
#ifdef DefaultRootWindow
    XRootWin = DefaultRootWindow(dpy);
#else
    XRootWin = RootWindow(dpy, DefaultScreen(dpy));
#endif
    XDefineCursor(dpy, XRootWin, XRootCur);
    XUnloadFont(dpy, CurFont);
    XCloseDisplay(dpy);
}
