#!/home/jimc/jxexit.d/xexit -F
# xexit -- button to terminate an X session
# Copyright (c) 1997 by James F. Carter.  1997-01-14, tcl/tk 7.4/4.0

# The X Consortium, and any party obtaining a copy of these files from
# the X Consortium, directly or indirectly, is granted, free of charge, a
# full and unrestricted irrevocable, world-wide, paid up, royalty-free,
# nonexclusive right and license to deal in this software and
# documentation files (the "Software"), including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons who receive
# copies from any such party to do so.  This license includes without
# limitation a license to do the foregoing actions under any patents of
# the party supplying this software to the X Consortium.
# 
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE X CONSORTIUM OR THE AUTHOR BE LIABLE FOR ANY CLAIM,
# DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
# OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
# THE USE OR OTHER DEALINGS IN THE SOFTWARE.
# 
# Except as contained in this notice, the name of the X Consortium shall
# not be used in advertising or otherwise to promote the sale, use or
# other dealings in this Software without prior written authorization
# from the X Consortium.



# This tcl code is hardwired into the xexit program.

# If the command line argument "now" is seen, the program immediately kills
# all clients and exits.  Absent "now", it waits for Button-1, pops up a
# confirmation dialog, and then kills clients.  The usual tk options can
# also be specified on the command line.

# Send a protocol atom to every window on the screen.  $indent is for debug
# printouts (if any).  Returns the number of windows that accepted the atom.
proc murder {win atom indent} {
    global mytop
    set count 0
    set indent [expr {$indent+4}]
    if {$win == $mytop} {
		# Do nothing: this is murder, not suicide.
    } elseif {[jxkill sendproto $win $atom]} {
		# Presumably the recipient will get rid of its child windows.
	set count 1
    } else {
		# Protocol was not accepted; see if the children will take it.
	foreach child [lrange [jxkill family $win] 2 end] {
	    incr count [murder $child $atom $indent]
	}
    }
    return $count
}

# Wait for a given multiple (decimal) of the time scale.
proc stall {time} {
    global timescale
    after [expr {int($time*$timescale+0.5)}]
}

# Kill everything.  No arguments.  
proc killall {} {
                # Locate the root, and its immediate child which is an ancestor
		# of this app's main window.  That child is excluded from
		# "kill" actions.
    global mytop
    update
    set mytop [winfo id .]
    while 1 {
	set fam [jxkill family $mytop]
	if {[lindex $fam 1] == [lindex $fam 0]} break
	set mytop [lindex $fam 1]
    }
    set root [lindex $fam 0]
    
		# Send the WM protocols first.
    if {[murder $root WM_SAVE_YOURSELF 0]} { update; stall 1 }
    if {[murder $root WM_DELETE_WINDOW 0]} { update; stall 1 }
    
		# Kill the remaining windows brutally.
    foreach win [lrange [jxkill family $root] 2 end] {
	if {$win == $mytop} continue
	jxkill kill $win
    }
    exit
}

# Put the appropriate text or bitmap in a label and show it.
proc waitlabel {type} {
    set w .killbait
    set bitmap @[option get . "${type}Bitmap" KillBitmap]
    if {$bitmap == "@"} {
	label $w -text [option get . "${type}Text" KillText] \
	    -font [option get . waitFont KillFont]
    } else {
	label $w -bitmap $bitmap
    }
    pack $w -in .
    return $w
}

proc setup {} {
    global argv0 argv now timescale

    option add *highlightThickness	0	widgetDefault
    option add *padX			1	widgetDefault
    option add *padY			1	widgetDefault
    #option add *waitBitmap		(itsname) widgetDefault
    option add *waitText		Logout	widgetDefault
    option add *waitFont -misc-*-medium-r-*-*-20-*-*-*-*-*-iso8859-1 \
								widgetDefault
    #option add *killBitmap		(itsname) widgetDefault
    option add *killText		Goodbye	widgetDefault
    option add *noconfirm		false	widgetDefault
    option add *confirmText		Logout	widgetDefault
    option add *declineText		Stay	widgetDefault
    option add *time			1000	widgetDefault

    set adfile /usr/X11/lib/X11/app-defaults/Xexit
    if {[file readable $adfile]} {
	option readfile $adfile startupFile
    }

    set confirm 1		;#1 if confirmation box wanted
    set now 0			;#1 for immediate kill
    for {set i 0} {$i < [llength $argv]} {incr i} {
	set a [lindex $argv $i]
	switch -- $a {
	    -now	{ set now 1 }
	    -noconfirm	{ set confirm 0 }
	    -xrm	{
		    set a [lindex $argv [incr i]]
		    set a [split $a ':']
		    set key [string trim [lindex $a 0]]
		    set value [string trim [lindex $a 1]]
		    option add $key $value interactive
		}
	    -F		{ incr i }
	    default		{ puts stderr "[winfo name .]: unrecognized option $a, expecting `-noconfirm' or `-now'" }
	}
    }
    
    if {[option get . noconfirm Noconfirm]} { set confirm 0 }
    set timescale [option get . time Time]
    
    . configure -borderwidth 2 -relief raised
    wm protocol . WM_DELETE_WINDOW {stall 2.5; exit}
    while {! $now} {
	set w [waitlabel wait]
	bind $w <Button-1> "destroy $w"
	tkwait window $w
	button .kill -text [option get . confirmText KillText] \
	    -command {set now 1; destroy .stay; destroy .kill}
	button .stay -text [option get . declineText KillText] \
	    -command {set now 0; destroy .stay; destroy .kill}
	pack .kill .stay -in . -side top -fill x -expand 1
	tkwait window .kill
    }
}

setup
waitlabel kill
killall    
