.TH XEXIT 1 "14 January 1997"
.SH NAME
xexit \- terminate an X\-windows session
.SH SYNOPSIS
.B xexit
[ \-F
.I script
] [\-noconfirm] [\-now] 
.BR
        [\-xrm
.I '*key:value'
]
.SH DESCRIPTION
.B xexit
places a window on the X desktop and waits for it to be clicked with Button\-1.
Then after a confirmation, it sends the window manager protocol atoms
WM_SAVE_YOURSELF and WM_DELETE_WINDOW to any windows (on the screen where it
has placed itself) which will accept them.  Finally it deletes all remaining
windows (except its own) using XKillClient, and exits.
.PP
.B xexit
would normally be the last client in a .xsession or .xinitrc file, so that
exiting signifies that the X session is finished.  It can also be used
autonomously to kill a session in the manner of xkill(1).  
.SS OPTIONS
.TP
.I "\-noconfirm"
Omit the confirmation dialog; kill on the first mouse click.  The user should
be careful where s/he clicks.  
.TP
.I "\-now"
Bypass both the waiting and the confirmation; kill immediately.  You can set
up a window manager procedure for shutting down your machine.  It would run (in the background in a subshell)
.B xexit
\-now, 
sleep a short while, and then run
.B shutdown
(1).
.TP
.I "\-xrm '*key:value'"
This is the general mechanism for setting Xresources, described below.  
Other standard X options are also recognized.  
.TP
.I "\-F script"
The programmatic commands in
.B xexit
can be used for other purposes if it is used to execute a user-provided 
tcl script.  A script is compiled into the executable to do the functions
described in this man page.  If used, \-F must be the first option.
.SH X RESOURCES
.PP
The class of each of the listed Xresources is derived by capitalizing the first
letter of the name.  Classes are not very useful for
.B xexit.
.TP
.I "waitBitmap"
Full path name of the bitmap to display while waiting to be clicked.
.TP
.I "waitText"
If there is no bitmap, this text is shown while waiting.  Default: Logout.
.TP
.I "waitFont"
The font in which to show the waitText and killText.  Default: a misc (fixed)
20 pixel font.
.TP
.I "killBitmap"
Full path name of the bitmap to display during the few seconds it takes to
kill the session.
.TP
.I "killText"
If there is no bitmap, this text is shown (in waitFont) while killing. 
Default: Goodbye.
.TP
.I "noconfirm"
Boolean; if true, the confirmation dialog is omitted.  Default: `false'.
.TP
.I "confirmText"
Text for the confirmation button.  Default: Logout.
.TP
.I "declineText"
Text for the nonconfirmation button.  Default: Stay.
.TP
.I "time"
Time in milliseconds to wait for clients to deal with the window manager
protocols.  If they do not exit by themselves within this time, their
windows are deleted brutally.  All participating clients receive 
WM_SAVE_YOURSELF, then the delay, then remaining clients receive 
WM_DELETE_WINDOW, then another delay, then the axe.  
.SS FILES
.TP
"/usr/X11/lib/X11/app-defaults/Xexit"
Application default Xresource file.  Normally missing; you can override the
compiled-in defaults in this file.  For example, here is where you would
specify bitmaps or non-English texts as a default for your site.
.SS SEE ALSO
xkill(1x)
.SS CAVEATS
When you execute
.B xexit
either from a window manager or from an xterm for testing, it will kill
the window manager and the xterm.  If it is an immediate child of what is
killed, it will die too, giving the impression of erratic performance. 
Run it in the background.  From the window manager, execute a shell which
puts
.B xexit
in the background.  
.PP
.B xexit
has to deal with windows that vanish at unpredictable times; thus it is
very tolerant of errors.  It may at times fail to recognize situations that
are truly erroneous.  
.PP
In testing, you can safely get rid of
.B xexit
with SIGINT (control-C), or by using the window manager to kill the window,
or by giving it WM_DELETE_WINDOW.  Fvwm has a ``close'' function for this
purpose.  When it receives WM_DELETE_WINDOW,
.B xexit
waits for 2.5*time before exiting, which helps in coordination when one
instance holds the end of .xsession and another runs autonomously to
kill the session. 
.SS VERSION
This is version 2.0.  
.SS HISTORY
As late as 1994, the X11R6 distribution's contrib portion included a program
called
.B xexit
by <Markus.Stumpf@Informatik.TU-Muenchen.DE>.  This program 
however disappeared from the distribution.  When the old source was
recompiled it turned out to be erratic in killing all the windows; also
the \-now feature was desired, as well as the possibility of text labels.  
.PP
Thus James F. Carter <jimc@math.ucla.edu> reimplemented the program using
tcl-tk.  The original code was used as a guide to doing the Xlib calls, and
the original bitmaps are included in the distribution.  One pair of bitmaps 
is by Markus Stumpf, and the cartoons are from Thomas 'TiCi' Thissen.  
