######################################################################
#
#  GTK.PL - wmtheme support for GTK themes
#

$tosite = 'gtk.classic.themes.org';
$badnamechars = '"';
$no_run_check = 1;
$gtkrc = "$home/.gtkrc-2.0";
$autoblurb = "# -- THEME AUTO-WRITTEN DO NOT EDIT";

insistdir("$home/.themes");

  ###
  #
  #  WM_GETDEFAULTDIRS
  #
  ###

sub wm_getdefaultdirs {
  my ($gtkconfig, $gtkprefix);
  my @guesses = ("$home/.themes");

  if ($gtkconfig = findexe('gtk-config') and
      $gtkprefix = `$gtkconfig --prefix`) {
    $gtkprefix =~ s!\n!/share/themes!;
    push @guesses, $gtkprefix;
  }

  verify_themedirs(0, @guesses, "/usr/share/themes",
    "/usr/local/share/themes");
}

  ###
  #
  #  WM_SCANDIR
  #
  ###

sub wm_scandir {
  my $dir = shift;
  my (%scanned, $entry, $owner);

  $scanned{$dir} = (stat $dir)[9];
  $owner = (stat _)[4];
  opendir DH, $dir or choke("Can't opendir $dir: $!");
  while (defined($entry = readdir DH)) {
    next if $entry =~ /^\.\.?$/;
    if (-f "$dir/$entry/gtk-2.0/gtkrc") {
      createthemerec($entry, "$dir/$entry", $owner);
    }
  }
  closedir DH;
  %scanned;
}

  ###
  #
  #  WM_INSTALLTHEME
  #
  ###

sub wm_installtheme {
  my ($location, $filename, $defname) = @_;
  my ($themename, $entry, $themedir);

  unless ($localthemedir) {
    choke("No local theme directory: can't install GTK themes");
  }

  unless (-d $location) {
    choke("GTK themes must be installed from a directory. (Internal error?)");
  }

  unless ($tlocation = findsubdirwithfile($location, 'gtk-2.0')) {
    choke("Can't find gtk-2.0 subdirectory; can't install.");
  }

  dbugout("TLocation is $tlocation") if $debug;

  if ($defname) {
    $themename = $defname;
  } else {
   ($themename = $tlocation) =~ s!.*\/([^/]+)$!$1!;
  }

  dbugout("Themename is $themename") if $debug;

  if (-f "$tlocation/gtk-2.0/gtkrc") {
    $themedir = $tlocation;
    dbugout("found themedir $themedir") if $debug;
    syscmd('mv', $themedir, "$localthemedir/$themename");
  } else {
    choke("Can't find gtk-2.0/gtkrc file; can't install");
  }

  createthemerec($themename, "$localthemedir/$themename", $>);
  $themename;
}

  ###
  #
  #  WM_ACTIVATETHEME
  #
  ###

sub wm_activatetheme {
  my ($themename, $explicit) = @_;
  my $rctext = '';
  my $include = "include \"$themes{$themename}{path}/gtk-2.0/gtkrc\"\n\ninclude \"$home/.gtkrc.mine\"\n";

  $rctext = slurpfile($gtkrc) if -e $gtkrc;

  if ($rctext =~ s/\Q$autoblurb\E.*\Q$autoblurb\E/$autoblurb\n$include\n$autoblurb/s) {
  } else {
    $rctext = "$autoblurb\n$include\n$autoblurb\n$rctext";
  }

  stowfile("$home/.gtkrc-2.0", $rctext);

  if (my $agtfile = findexe('apply-gtk2-theme', '.')) {
    syscmd($agtfile);
  }
}

  ###
  #
  #  WM_UNINSTALLTHEME
  #
  ###

sub wm_uninstalltheme {
  my $themename = shift;

  dirwipe($themes{$themename}{path}, 1);
}

  ###
  #
  #  WM_RENAME
  #
  ###

sub wm_rename {
  my ($old, $new) = @_;
  my $path = $themes{$old}{path};

  if ($path =~ s!/\Q$old\E$!/$new!) {
    system('mv', $themes{$old}{path}, $path);
    $path;
  } else {
    choke("Internal error: couldn't strip \"$old\" from the end of $path");
  }
}

  ###
  #
  #  WM_VERSIONOK
  #
  ###

sub wm_versionok {
  1;
}

1;

