/*
 * wmjulia is a windowmaker / afterstep dock/wharf applet for GNU/Linux
 *
 * It draws spinning julia sets which can be adjusted with little buttons
 *
 * Code based on some of the Window maker programs found on the internet
 *
 * Code based on wmpong, by Dag Wieers <dag@digibel.be>
 *
 * Copyright 1999, Dave Turner (turnerd@reed.edu);
 *
 * This program is distributed under the GPL license. 
 *
 * Thanks to Richard Stallman for the GNU system and the GPL.
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <math.h>

#include <X11/xpm.h>

#include "../wmgeneral/wmgeneral.h"

#include "wmjulia_master.xpm"

#define USLEEP 20000


struct xpm_position
  {
    int x, y;
  };
struct xpm_surface
  {
    int x, y, w, h;
  };



struct xpm_position pos[] =
{
  {5, 50},
  {16, 50},
  {27, 50},
  {38, 50},
  {49, 50}
};
struct xpm_surface rel[] =
{
  {1, 70, 11, 9},
  {12, 70, 11, 9},
  {23, 70, 11, 9},
  {34, 70, 11, 9},
  {45, 70, 11, 9}
};
struct xpm_surface prs[] =
{
  {1, 79, 11, 9},
  {12, 79, 11, 9},
  {23, 79, 11, 9},
  {34, 79, 11, 9},
  {45, 79, 11, 9}
};




char wmjulia_pm[64][48];


/*****************************************************************************/

void do_frame (double cx, double cy) {

  int x, y, i, done;

  double zx, zy, zx2, zy2;

  for (y = 47; y >= 0; y --) {
   
    for (x = 6; x < 58; x ++) {
      
      zx = ((float) (x - 32)) / 15;
      zy = ((float) (y - 24)) / 15;

      done = 0;

      for (i = 0; (i < 31) && (done == 0); i ++) {
	zx2 = zx * zx;
	zy2 = zy * zy;
	zy = 2 * zx * zy + cy;
	zx = zx2 - zy2  + cx;
	if (zx2 >= 4 || zy2 >= 4) done = 1;
      }
      wmjulia_pm [x][y] = i * 2;
    }
  }

}


/*****************************************************************************/

void paint_frame () {

  // I really wish wmgeneral allowed a better way to implement this.
  // I tried to write one, but Xlib is too twisted for me at this time.

  int x, y;
  for (y = 47; y >= 0; y --) {
    for (x = 1; x < 63; x ++) {

      copyXPMArea (wmjulia_pm[x][y], 67, 1, 1, x, y);
    }
  }
  

}
/*****************************************************************************/

void main (int argc, char *argv[]) {
  XEvent Event;

  char wmjulia_mask_bits[64*64];
  int wmjulia_mask_width = 64;
  int wmjulia_mask_height = 64;

  double cx, cy, angle = 0;

  double speed = 0.05, radius = 1;

  int i;

  createXBMfromXPM (wmjulia_mask_bits, wmjulia_master_xpm, wmjulia_mask_width, wmjulia_mask_height);
  openXwindow (argc, argv, wmjulia_master_xpm, wmjulia_mask_bits, wmjulia_mask_width, wmjulia_mask_height);

  for (i = 0; i < 5; i++)
    AddMouseRegion (i, pos[i].x, pos[i].y, pos[i].x + prs[i].w, pos[i].y + prs[i].h);


  while (1) {
    angle += speed;
    cx = cos (angle) * radius;
    cy = sin (angle) * radius;

    do_frame (cx, cy);
    paint_frame ();
    
    RedrawWindow ();

    while (XPending (display)) {
      XNextEvent (display, &Event);
      switch (Event.type) {

      case Expose:
	RedrawWindow ();
	break;
      case DestroyNotify:
	XCloseDisplay (display);
	exit (0);
	break;
      case ButtonPress:
	i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
	copyXPMArea (prs[i].x, prs[i].y, prs[i].w, prs[i].h, pos[i].x, pos[i].y);
	switch (i)
	  {
	  case 0:
	    radius += 0.01;
	    if (radius <= 0) radius = 0.01;
            break;
	  case 1:
	    radius -= 0.01;
	    break;
	  case 2:
	    speed += 0.01;
	    break;
	  case 3:
	    speed -= 0.05;
	    if (speed < 0) speed = 0;
	    break;
	  case 4:
	    radius = 1;
	    speed = 0.05;
            break;
	  }
	break;
      case ButtonRelease:
	i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
	copyXPMArea (rel[i].x, rel[i].y, rel[i].w, rel[i].h, pos[i].x, pos[i].y);
	break;
      }
    }
    usleep (USLEEP);
  }
}

