/*
 * wmflame is a windowmaker / afterstep dock/wharf applet for GNU/Linux
 *
 * It draws flames which can be adjusted with little buttons
 *
 * Code based on some of the Window maker programs found on the internet
 *
 * Code based on wmpong, by Dag Wieers <dag@digibel.be>
 *
 * Copyright 1999, Dave Turner (turnerd@reed.edu);
 *
 * This program is distributed under the GPL license. 
 *
 * Thanks to Richard Stallman for the GNU system and the GPL.
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>

#include <X11/xpm.h>

#include "../wmgeneral/wmgeneral.h"

#include "wmflame-master.xpm"

#define USLEEP 20000
#define MAX_COLORS 10		/* don't change these */
#define X_MIN 5
#define X_MAX 55.0
#define Y_MIN 5
#define Y_MAX 44.0

struct xpm_position
  {
    int x, y;
  };
struct xpm_surface
  {
    int x, y, w, h;
  };



struct xpm_position pos[] =
{
  {5, 50},
  {16, 50},
  {27, 50},
  {38, 50},
  {49, 50}
};
struct xpm_surface rel[] =
{
  {1, 70, 11, 9},
  {12, 70, 11, 9},
  {23, 70, 11, 9},
  {34, 70, 11, 9},
  {45, 70, 11, 9}
};
struct xpm_surface prs[] =
{
  {1, 79, 11, 9},
  {12, 79, 11, 9},
  {23, 79, 11, 9},
  {34, 79, 11, 9},
  {45, 79, 11, 9}
};



char seed_line [64];

char wmflame_pm[64][48];

/*****************************************************************************/

void init_seeds () {

  int i;

  for (i = 0; i < 64; i ++) {
    seed_line [i] = (rand() % 64);
  }

}

/*****************************************************************************/

void permute_seeds () {

  int i;

  for (i = 0; i < 64; i ++) {
    seed_line [i] = seed_line [i] - 5 + (rand() % 11);
    if (seed_line [i] < 0) seed_line [i] = 0;
    if (seed_line [i] > 70) seed_line [i] = 70;
  }

}

/*****************************************************************************/

void do_frame (float divisor, int random_amt) {

  int x, y;

  for (x = 1; x < 63; x ++) {
    wmflame_pm [x][48] = ((seed_line [x - 1] + seed_line [x] + seed_line [x + 1]) / 2);
  }

  // this is where the fun goes on.  We sort of "blur up" the flame.  
  // There's no color going on yet, just an array of intensity or heat values.
  // each pixel gets an average of the point to its right, itself, and the 
  // three below it, minus a random little bit.  The addition of the point to 
  // the right of the pixel makes the flame appear to move left as though 
  // blown by a breeze.  the divisor is alwats around 5, which is the number 
  // of values being averaged.  

  for (y = 47; y >= 1; y --) {
    for (x = 1; x < 62; x ++) {
      wmflame_pm [x][y] = (-(rand() % random_amt) + wmflame_pm [x + 1][y] + wmflame_pm [x][y] + wmflame_pm [x - 1][y + 1] + wmflame_pm [x][y + 1] + wmflame_pm [x + 1][y + 1]) / divisor;
    }
  }

  //now clean up.  set values less than zero to zero, and values greater than 63 to 63.

  for (y = 47; y >= 1; y --) {
    for (x = 1; x < 62; x ++) {
      if (wmflame_pm [x][y] > 63) {
	wmflame_pm [x][y] = 63;
      } else {
        if (wmflame_pm [x][y] < 0) {
          wmflame_pm [x][y] = 0;
        }
      }
    }
  }



}


/*****************************************************************************/

void paint_frame () {

  // I really wish wmgeneral allowed a better way to implement this.
  // I tried to write one, but Xlib is too twisted for me at this time.

  int x, y;
  for (y = 47; y >= 0; y --) {
    for (x = 1; x < 63; x ++) {

      copyXPMArea (wmflame_pm[x][y], 67, 1, 1, x, y);
    }
  }
  

}
/*****************************************************************************/

void main (int argc, char *argv[]) {
  XEvent Event;

  char wmflame_mask_bits[64*64];
  int wmflame_mask_width = 64;
  int wmflame_mask_height = 64;

  int random_amt = 12;   // these two values were obtained through trial
  float divisor = 4.89;  // and error.  Change them here, or with the 
                         // little buttons.

  int i;


  srand (time (NULL));

  init_seeds ();

  createXBMfromXPM (wmflame_mask_bits, wmflame_master_xpm, wmflame_mask_width, wmflame_mask_height);
  openXwindow (argc, argv, wmflame_master_xpm, wmflame_mask_bits, wmflame_mask_width, wmflame_mask_height);

  for (i = 0; i < 5; i++)
    AddMouseRegion (i, pos[i].x, pos[i].y, pos[i].x + prs[i].w, pos[i].y + prs[i].h);


  while (1) {
    permute_seeds ();
    do_frame (divisor, random_amt);
    paint_frame ();
    
    RedrawWindow ();

    while (XPending (display)) {
      XNextEvent (display, &Event);
      switch (Event.type) {

      case Expose:
	RedrawWindow ();
	break;
      case DestroyNotify:
	XCloseDisplay (display);
	exit (0);
	break;
      case ButtonPress:
	i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
	copyXPMArea (prs[i].x, prs[i].y, prs[i].w, prs[i].h, pos[i].x, pos[i].y);
	switch (i)
	  {
	  case 0:
	    divisor -= .01;
	    if (divisor <= 0) divisor = .01;
            break;
	  case 1:
	    divisor += .01;
	    break;
	  case 2:
	    random_amt += 1;
	    break;
	  case 3:
	    random_amt -= 1;
	    if (random_amt < 1) random_amt = 1;
	    break;
	  case 4:
	    init_seeds ();
            break;
	  }
	break;
      case ButtonRelease:
	i = CheckMouseRegion (Event.xbutton.x, Event.xbutton.y);
	copyXPMArea (rel[i].x, rel[i].y, rel[i].w, rel[i].h, pos[i].x, pos[i].y);
	break;
      }
    }
    usleep (USLEEP);
  }
}

