#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <X11/xpm.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#include "propsel1.xpm"
#include "propsel2.xpm"

#undef DEBUG

#define PROPERTY "PROPSEL_SELECTION"
#define WAIT_MSEC 300
#define WAIT_USEC (WAIT_MSEC*1000)

#define MAX_DISPLAYS 8

#define EVENTS (ButtonReleaseMask|ButtonPressMask|PointerMotionMask|ExposureMask)

#define Nobody -1	/* must be number that other than 0..MAX_DISPLAYS */

void Usage(void)
{
#define P(ARG) fprintf(stderr,ARG)
#define P2(ARG,ARG2) fprintf(stderr,ARG,ARG2)
P("Usage: propsel -remote <display> [-local <display>] [-remote <display> [...]]\n");
P("-local  overrides DISPLAY environment variable\n");
P("-remote defines other displays. If only one appears, other is taken from the\n");
P("        DISPLAY environment variable\n");
P2("Up to %d displays can be used.\n",MAX_DISPLAYS);
P("\nWritten by Amit Margalit (http://hishome.net/~amit/)\n");
P("For help - propsel@hishome.net\n");
#undef P
#undef P2
  exit(1);
}

void strlwr(char *s)
{
  while(*s)
  {
    *s=tolower(*s);
    s++;
  }
}

void main(int argc, char *argv[])
{
  Display *disp[MAX_DISPLAYS];
  Window win[MAX_DISPLAYS];
  Time last[MAX_DISPLAYS];
  XEvent xev;
  XSelectionClearEvent *xselclr;
  XSelectionEvent *xsel,xsend;
  XSelectionRequestEvent *xselreq;
  XClientMessageEvent *xclimsg;
  XButtonEvent *xbut;
  Atom prop[MAX_DISPLAYS],type_ret;
  int format_ret,disps=0,i,j,sleep=0;
  unsigned long items_ret,left_ret;
  unsigned char *storage;
  Pixmap selected[MAX_DISPLAYS],click2sel[MAX_DISPLAYS];
  XpmAttributes xpm_attr;	/* needed to ask for size and set closeness */
  int current_owner=Nobody;		/* nobody... */

  char *disp_name[MAX_DISPLAYS];

  /* init */

  xselclr = (XSelectionClearEvent*)&xev;
  xselreq = (XSelectionRequestEvent*)&xev;
  xsel    = (XSelectionEvent*)&xev;
  xclimsg = (XClientMessageEvent*)&xev;
  xbut    = (XButtonEvent*)&xev;

  xpm_attr.valuemask = XpmCloseness; /* ask for size and set closeness */
  xpm_attr.closeness = 36000;	     /* wanted closeness value */

  if(argc==1)
    Usage();

  /* use the DISPLAY var. */
  disp_name[0]=NULL; disps++;

  /* parse commandline */
  for(i=1;i<argc;i++)
  {
    strlwr(argv[i]);
    if(strncmp(argv[i],"-l",2)==0)
    {
      if(i+1>=argc)
        Usage();
      disp_name[0]=argv[++i];
    }
    if(strncmp(argv[i],"-r",2)==0)
    {
      if(i+1>=argc)
        Usage();
      disp_name[disps++]=argv[++i];
    }
  }

  /* open the displays */
  for(i=0;i<disps;i++)
  {
    disp[i]=XOpenDisplay(disp_name[i]);
    if(disp[i]==NULL)
    {
      fprintf(stderr,"Could not open display %s\n",
      	(disp_name[i]==NULL?"NULL":disp_name[i]));
      exit(1);
    }
    /* the selection property */
    prop[i]=XInternAtom(disp[i],PROPERTY,False);
    /* make us a window */
    win[i]=XCreateSimpleWindow(disp[i],DefaultRootWindow(disp[i]),0,0,76,64,0,
    		BlackPixel(disp[i],0),BlackPixel(disp[i],0));
    if(win[i]==0)
    {
      fprintf(stderr,"Error creating window on display %s\n",
      	(disp_name[i]==NULL?"NULL":disp_name[i]));
      exit(1);
    }
    /* put the prop on our win */
    XChangeProperty(disp[i],win[i],prop[i],XA_STRING,8,PropModeReplace,(unsigned char*)"A",1);
    /* now let's see the window */
    XMapWindow(disp[i],win[i]);
    /* Let's get some input */
    XSelectInput(disp[i],win[i],EVENTS);

    XpmCreatePixmapFromData(disp[i],win[i],click_xpm,
    		&(click2sel[i]),NULL,&xpm_attr);
    XpmCreatePixmapFromData(disp[i],win[i],selected_xpm,
    		&(selected[i]),NULL,&xpm_attr);
  }

  while(1)
  {

    for(i=0;i<disps;i++)
    {
      if(XQLength(disp[i])>0)
      {
        XNextEvent(disp[i],&xev);
#ifdef DEBUG
        printf("%s: ",(disp_name[i]==NULL?"NULL":disp_name[i]));
	fflush(stdout);
#endif
        switch(xev.type)
        {
	case Expose:
	  if(current_owner == i || current_owner == Nobody)
	    XCopyArea(disp[i],click2sel[i],win[i],DefaultGC(disp[i],0),
	    		0,0,76,64,0,0);
	  else
	    XCopyArea(disp[i],selected[i],win[i],DefaultGC(disp[i],0),
	    		0,0,76,64,0,0);
	  XSync(disp[i],False);
	  break;
        case ButtonRelease:	/* any button will select */
#ifdef DEBUG
	  printf("ButtonRelease\n");
          fflush(stdout);
#endif
          XConvertSelection(disp[i],XA_PRIMARY,XA_STRING,prop[i],win[i],xbut->time);
          last[i] = xbut->time;
          break;
        case SelectionClear:
#ifdef DEBUG
          printf("SelectionClear\n");
          fflush(stdout);
#endif
          last[i] = xselclr->time;
          current_owner=Nobody;
          storage=NULL;
          break;
        case SelectionNotify:
#ifdef DEBUG
          printf("SelectionNotify\n");
          fflush(stdout);
#endif
          last[i] = xsel->time;
          if(xsel->property==None)
          {
#ifdef DEBUG
            printf("Selection Owner claims it can't supply a string.\n");
#endif
            fflush(stdout);
          }
          if(xsel->property==prop[i]) /* success */
          {
            XGetWindowProperty(disp[i],win[i],prop[i],0,10240,False,XA_STRING,&type_ret,
            	&format_ret,&items_ret,&left_ret,&storage);
            storage[items_ret]=0;
#ifdef DEBUG
            printf("Selection is: %s\n",storage);

            /* let's become the owners of the selection */
            printf("Trying to acquire remote selection ownership.\n");
            fflush(stdout);
#endif
	    /* we are the owners now... */
	    current_owner = i;
	    for(j=0;j<disps;j++)
	    {
	      if(j==i)
	        continue;
              while(XGetSelectionOwner(disp[j],XA_PRIMARY)!=win[j])
                XSetSelectionOwner(disp[j],XA_PRIMARY,win[j],CurrentTime);

  	      XCopyArea(disp[j],selected[j],win[j],DefaultGC(disp[j],0),
  	    		0,0,76,64,0,0);
  	      XSync(disp[j],False);
#ifdef DEBUG
              printf("Local: Got it!\n");
              fflush(stdout);
              XSetSelectionOwner(disp[j],XA_PRIMARY,win[j],CurrentTime);
#endif
	    }
          }
          break;
        case SelectionRequest:
#ifdef DEBUG
          printf("SelectionRequest\n");
	  printf("xselreq->owner %s win[i] (%x)\n",(xselreq->owner==win[i]?"==":"!="),(int)xselreq->owner);
          fflush(stdout);
#endif
          last[i] = xselreq->time;
	  xsend.type = SelectionNotify;
	  xsend.requestor = xselreq->requestor;
	  xsend.selection = xselreq->selection;
	  xsend.target = xselreq->target;
	  xsend.time = xselreq->time;
	  xsend.property = xselreq->property;
  	  if(xselreq->selection != XA_PRIMARY ||  /* huh??? how come? */
  	         xselreq->target != XA_STRING || storage==NULL)
  	    xsend.property = None;
  	  else
  	    XChangeProperty(disp[i],xselreq->requestor,xselreq->property,
  	  	XA_STRING,8,PropModeReplace,storage,strlen((char*)storage));
	  /* send it! */
	  XSendEvent(disp[i],xselreq->requestor,False,0,(XEvent*)&xsend);
            break;
        default:
#ifdef DEBUG
          printf("Other...\n");
  	  fflush(stdout);
#endif
          break;
        }
      } /* events in Q */
      XSync(disp[i],False);
    }
    sleep=1; /* we need to sleep */
    for(j=0;j<disps;j++)
      if(XQLength(disp[j])>0)
      {
        sleep=0;
        break;
      }
    if(sleep)
      usleep(WAIT_USEC);
  }
}
