/************************************************************\
|* main.c -- Main program of the vidmode selector program   *|
|************************************************************|
|* By: Steve Conley.  [c]1998 Serpentine Network Industries *|
|* Availible under the Gnu Public License                   *|
\************************************************************/

/* System includes */
#include <stdio.h>

/* Project includes */
#include "libsx/src/libsx.h"

/* Where is your XServers file? */
char*	xservers="/var/X11R6/lib/xdm/Xservers";

/* What to write to file.  %i is the mode number */
char*	output=
"# $XConsortium: Xserv.ws.cpp,v 1.3 93/09/28 14:30:30 gildea Exp $\n"
"#\n"
"# Xservers file, workstation prototype\n"
"#\n"
"# This file should contain an entry to start the server on the\n"
"# local display; if you have more than one display (not screen),\n"
"# you can add entries to the list (one per line).  If you also\n"
"# have some X terminals connected which do not support XDMCP,\n"
"# you can add them here as well.  Each X terminal line should\n"
"# look like:\n"
"#       XTerminalName:0 foreign\n"
"#\n"
":0 local /usr/X11R6/bin/X -bpp %i\n";



void	SetMode(Widget w,void* data);

int	main(int argc,char** argv){
	int	i=8,j=16,k=24;
	Widget	w[4];

	argc=OpenDisplay(argc,argv);
	w[0]=MakeLabel("Choose a screen depth:");
	w[1]=MakeButton("8 bit",SetMode,(int*)&i);
	w[2]=MakeButton("16 bit",SetMode,(int*)&j);
	w[3]=MakeButton("24 bit",SetMode,(int*)&k);
	SetWidgetPos(w[1],PLACE_UNDER,w[0],NO_CARE,NULL);
	SetWidgetPos(w[2],PLACE_UNDER,w[1],NO_CARE,NULL);
	SetWidgetPos(w[3],PLACE_UNDER,w[2],NO_CARE,NULL);
	MainLoop();
}

void	SetMode(Widget w,void* data){
	FILE*	out;
	int	i;

	i=*(int*)data;
	out=fopen(xservers,"w");
	if(!out)
		return;
	fprintf(out,output,i);
	fclose(out);
}
