/*************************************************************************
 *                                                                       *
 *  KDisk Utils - KSlot V0.9.0                                           *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@wilhelmshaven-online.de                            *
 *                                                                       *
 *************************************************************************/

#include <qpoint.h>

#include <kwm.h>
#include <kmsgbox.h>

#include "kslot.h"

extern "C"	changeSlot(int,const char *);

KSlotWidget::~KSlotWidget(){
}

KSlotWidget::KSlotWidget(QWidget *parent, const char *name, bool):QWidget(parent,name){
	readSettings();

	brush_0 = QBrush(QColor(  0,  0,  0), SolidPattern);
	brush_1 = QBrush(QColor(  0,225,  0), SolidPattern);
	brush_2 = QBrush(QColor(255,  0,  0), SolidPattern);

	slotmenu=new QPopupMenu;
	CHECK_PTR(slotmenu);
	slotmenu->insertItem(klocale->translate("&Set Device"),this, SLOT(setDevice()),0);
	slotmenu->insertItem(klocale->translate("&About"),this, SLOT(about()),0);
	slotmenu->insertSeparator();
	slotmenu->insertItem(klocale->translate("&Quit KSlot"),this, SLOT(quit()),0);

	cfgdialog=new KSlotConfigDLG();
	connect(cfgdialog,SIGNAL(deviceSet(QString)),SLOT(applyDevice(QString)));
	
	slot=1;
	changeSlot(slot-1,device.data());		
}

void KSlotWidget::paintEvent(QPaintEvent *){
	QPainter p;
	
	p.begin(this);
	p.setPen(black);

	if (slot==1) p.setBrush(brush_2); else p.setBrush(brush_1);
	p.drawEllipse(6, 2, 10, 5);

	if (slot==2) p.setBrush(brush_2); else p.setBrush(brush_1);
	p.drawEllipse(6, 9, 10, 5);

	if (slot==3) p.setBrush(brush_2); else p.setBrush(brush_1);
	p.drawEllipse(6, 16, 10, 5);

	p.end();
}

void KSlotWidget::mouseReleaseEvent(QMouseEvent *e){
	int oldslot=slot;
	KMsgBox	*error;

	QPoint tmp_point=QCursor::pos();

	if (e->button()==LeftButton){

		if ((e->y()>=2)&&(e->y()<=7)){
			slot=1;
		}else if ((e->y()>=9)&&(e->y()<=14)){
			slot=2;
		}else if ((e->y()>=16)&&(e->y()<=21)){
			slot=3;
		}
		int stat=changeSlot(slot-1,device.data());
		
		if (stat!=0){
			slot=oldslot;
			error=new KMsgBox (NULL,klocale->translate("Error"),klocale->translate("Unresolvable error!"),KMsgBox::EXCLAMATION,"Ok");
			if (stat==1) error=new KMsgBox (NULL,klocale->translate("Error"),klocale->translate("Could not open device!"),KMsgBox::EXCLAMATION,"Ok");
			else if (stat==2) error=new KMsgBox (NULL,klocale->translate("Error"),klocale->translate("Could not change slot. You must unmount the device before changing!"),KMsgBox::EXCLAMATION,"Ok");
			else if (stat==3) debug("Closing the device caused an Error!");

			error->show();
		}
	}else{
		slotmenu->popup(tmp_point);		
	}

	repaint();
}

void KSlotWidget::quit(){
	kapp->quit();
}

void KSlotWidget::about(){
	KMsgBox	*aboutbox;
	aboutbox=new KMsgBox (NULL,klocale->translate("About KSlot"),
		klocale->translate("KDisk Utils - KSlot V0.9.0\n\n"
				"Written by Christian Poulter (cpoulter@wilhelmshaven-online.de)\n"
				"Copyright (c) 1998 by Christian Poulter\n\n"
				"This program is free software; you can redistribute it and/or modify\n"
				"it under the terms of the GNU General Public License as published by\n"
				"the Free Software Foundation - version 2.\n\n"
				"This program is distributed in the hope that it will be useful,\n"
				"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
				"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
				"GNU General Public License in file COPYING for more details.\n\n"
				"Have a lot of Fun!\n")
		,KMsgBox::INFORMATION,"Ok");
	
	aboutbox->show();
}

void KSlotWidget::setDevice(){
	cfgdialog->setDevice(device);
	cfgdialog->show();
}

void KSlotWidget::applyDevice(QString d){
	device=d;

	QString entry;

	KConfigBase *config;
	config=	KApplication::getKApplication()->getConfig();
	config->setGroup("Device");
 	config->writeEntry("Device",device);
	config->sync();
}

void KSlotWidget::readSettings(){
	KConfigBase *config;
	config=	KApplication::getKApplication()->getConfig();
	config->setGroup("Device");

	device=config->readEntry("Device","/dev/cdrom");
}

int main(int argc,char *argv[]){
 	KApplication *thisapp=new KApplication(argc,argv,"kslot");
	KSlotWidget *kslw=new KSlotWidget(0,0,WStyle_NormalBorder); 

	thisapp->setMainWidget(kslw);
	KWM::setDockWindow(kslw->winId());
	kslw->show();

	return thisapp->exec();
}

