/*************************************************************************
 *                                                                       *
 *  KDisk Utils - KSlot V0.9.0                                           *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@wilhelmshaven-online.de                            *
 *                                                                       *
 *************************************************************************/

#include "configdlg.h"
#include <kapp.h>

KSlotConfigDLG::~KSlotConfigDLG(){
}

KSlotConfigDLG::KSlotConfigDLG(QWidget *parent, const char *name, bool):QDialog(parent,name){
	setMinimumWidth(310);
	setMinimumHeight(120);

	info=new QLabel(this);
	info->setText(klocale->translate("Enter CD-ROM Device (probable /dev/cdrom):"));
	eingabe=new QLineEdit(this);
	
	ok=new QPushButton(this);
	ok->setText(klocale->translate("Ok"));

	cancel=new QPushButton(this);
	cancel->setText(klocale->translate("Cancel"));

	connect(ok,SIGNAL(clicked()),SLOT(okClicked()));
	connect(cancel,SIGNAL(clicked()),SLOT(cancelClicked()));

	adjustSize();
}

void KSlotConfigDLG::okClicked(){
	close();
	emit deviceSet(eingabe->text());
}

void KSlotConfigDLG::cancelClicked(){
	close();
}

void KSlotConfigDLG::resizeEvent(QResizeEvent *){
	info->setGeometry(20,20,width()-40,20);
	eingabe->setGeometry(20,45,width()-40,20);
	cancel->move(width()-cancel->width()-20,80);
	ok->move(width()-cancel->width()-ok->width()-40,80);
}

void KSlotConfigDLG::setDevice(QString d){
	eingabe->setText(d);
}

