/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.1                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@wilhelmshaven-online.de                            *
 *  E-Mail will change soon!!                                            *
 *  You should try virtual-dynamics@gmx.net                              *
 *                                                                       *
 *************************************************************************/

#include "page.h"
#include <qpainter.h>
#include <qpixmap.h>
#include <qbrush.h>

Page::~Page(){
}

Page::Page(QWidget *parent, diskData *d):QWidget (parent){
	dd=d;
	resize(450,300);

	disksymbol=new QLabel(this);
	diskname=new QLabel(this);
	disktyp=new QLabel(this);
	usedmem=new QLabel(this);
	freemem=new QLabel(this);
	header=new QLabel(this);
	usedmemi=new QLabel(this);
	freememi=new QLabel(this);
	grafik=new QLabel(this);
	diskinfo=new QLabel(this);

	disksymbol->setText(klocale->translate("Couldnt load icon!"));
	disksymbol->setAlignment( AlignCenter );

	usedmemi->setBackgroundColor(darkMagenta);
	freememi->setBackgroundColor(blue);

	setMinimumSize(size());

	setPath();
}

void Page::paintEvent(QPaintEvent *){
	QPainter p;  
	QBrush bblue;
	QBrush bred;
	int a2=(int)(5760*dd->disk_used/dd->disk_capacity);
	int a1=5760-a2;

	p.begin(grafik);

	bblue.setColor(blue);
	bblue.setStyle(SolidPattern);
	bred.setColor(darkMagenta);
	bred.setStyle(SolidPattern);

	p.setPen(blue);
	for (int i=0;i<16;i++) p.drawArc(16,3+i,119,30,0,a1);
	p.setPen(darkMagenta);
	for (int i=0;i<16;i++) p.drawArc(16,3+i,119,30,0,-a2);
	p.setPen(black);
	for (int i=0;i<16;i++) p.drawArc(16,3+i,119,30,a1,0);
	p.setBrush(bblue);
	p.drawPie(15,3,120,30,0,a1);
	p.setBrush(bred);
	p.drawPie(15,3,120,30,0,-a2);
	p.drawArc(15,18,120,30,0,-2880);
	p.drawLine(15,18,15,33);
	p.drawLine(134,18,134,33); 
	p.end();
}

void Page::resizeEvent(QResizeEvent *){
	disksymbol->setGeometry(30,30,32,32);
	diskname->setGeometry(92,30,width()-112,15);
	disktyp->setGeometry(92,47,width()-112,15);
	usedmemi->setGeometry(30,100,15,15);
	freememi->setGeometry(30,120,15,15);
	usedmem->setGeometry(50,100,width()-200,15);
	freemem->setGeometry(50,120,width()-200,15);
	header->setGeometry(30,140,width()-50,15);
	grafik->setGeometry(width()-160,100,150,55);

	diskinfo->setGeometry(30,180,width()-200,100);
}

QString Page::fitSize(float s, bool c){
	char einheit[6]="Bytes";
	char result[300]="";

	if (c){
		if (s>1000){
			s=s/1024;
			einheit="Kb   ";
		}
		if (s>1000){
			s=s/1024;
			einheit="Mb   ";
		}
		if (s>1000){
			s=s/1024;
			einheit="Gb   ";
		}
		sprintf(result,"%.2f %s",s,einheit);	
	}else{
		sprintf(result,"%.2f",s);	
	}

	QString tmp=result;
	if (tmp.right(3)==".00") tmp=tmp.left(tmp.length()-3);
	return tmp;
}

void Page::setPath(){
	diskname->setText(klocale->translate("Device: ")+dd->device);
	disktyp->setText(klocale->translate("Device-Typ: ")+dd->filesystem);
	usedmem->setText(klocale->translate("Used Memory: ")+fitSize(+dd->disk_used,true)+" ( "+fitSize((+dd->disk_used*100/+dd->disk_capacity),false)+"% )");
	freemem->setText(klocale->translate("Free Memory: ")+fitSize(+dd->disk_capacity-+dd->disk_used,true)+" ( "+fitSize(((+dd->disk_capacity-+dd->disk_used)*100/+dd->disk_capacity),false)+"% )");
	header->setText(klocale->translate("Capacity: ")+fitSize(+dd->disk_capacity,true));
	diskinfo->setText(klocale->translate("Device: ")+dd->device+"\n"
			 +klocale->translate("Mounted on: ")+dd->mountpoint+"\n"
			 +klocale->translate("FS-Type: ")+dd->filesystem+"\n"
			 +klocale->translate("Blocks: ")+dd->disk_blocks+"\n"
			 +klocale->translate("Blocksize: ")+dd->disk_bl_size+"\n"
			 +klocale->translate("Options: ")+dd->readwrite);

	QString ic="";

	if (dd->filesystem=="minix") ic="3floppy_umount.xpm";
	if (dd->filesystem=="ext2") ic="blockdevice.xpm";
	if (dd->filesystem=="vfat") ic="blockdevice.xpm";
	if (dd->filesystem=="nfs") ic="network.xpm";
	if (dd->filesystem=="iso9660") ic="cdrom_unmount.xpm";
	if (dd->filesystem=="msdos") ic="zip_unmount.xpm";

	disksymbol->setPixmap(QPixmap(kapp->kde_icondir()+"/"+ic));
	disksymbol->repaint();
}

