/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.1                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@wilhelmshaven-online.de                            *
 *  E-Mail will change soon!!                                            *
 *  You should try virtual-dynamics@gmx.net                              *
 *                                                                       *
 *************************************************************************/
#include "kdfree.h"
#include "diskdata.h"
#include "page.h"
#include <stdio.h>

KDFree::~KDFree(){
}

KDFree::KDFree(QWidget *parent, const char *name, bool modal, QString path):QTabDialog(parent,name,modal){
	FILE *mountfile;
	Page *pages;
	Page *fp=NULL;
	char device[100];
	char mountpoint[200];
	char filesystem[100];
	char readwrite[100];
	int a,b;
	diskData *dd;

	summary=new Summary(this);
	addTab(summary,klocale->translate("Summary"));

	mountfile=fopen("/proc/mounts","r");
	setvbuf(mountfile,NULL,_IONBF,0);

	rewind(mountfile);
	while(fscanf(mountfile, "%s %s %s %s %d %d", device, mountpoint, filesystem, readwrite, &a, &b)!=EOF){
		if (QString(filesystem)!="proc"){
			dd=new diskData(mountpoint,filesystem,readwrite,device);
			pages=new Page(this,dd);
			addTab(pages,mountpoint);
			if (QString(mountpoint)+"/"==path) fp=pages;
			if (QString(mountpoint)==path) fp=pages;
			summary->addDrive(dd);
		}
	}

	addTab(new Info(this),klocale->translate("Info"));

	show();
	
	setOkButton();
	setDefaultButton(klocale->translate("Help"));
	if (fp!=NULL) showPage(fp);

	connect(this,SIGNAL(applyButtonPressed()),SLOT(close()));
	connect(this,SIGNAL(defaultButtonPressed()),SLOT(help()));
}

void KDFree::close(){
	kapp->quit();
}

void KDFree::help(){
	KApplication::getKApplication()->invokeHTMLHelp("kdu/kdfree.html","");
}

int main(int argc,char *argv[]){
 	KApplication *thisapp=new KApplication(argc,argv,"kdfree");
 
	KDFree *main=new KDFree(NULL,NULL,false,argv[1]); 

	thisapp->setTopWidget(main);
	thisapp->setMainWidget(main);

	return thisapp->exec();
}

